class Navigate {
  cleanArray (actual) {
    const newArray = []
    for (let i = 0; i < actual.length; i++) {
      if (actual[i]) {
        newArray.push(actual[i])
      }
    }
    return newArray
  }

  /**
   * 转换queryString
   * @returns {*}
   */
  toQueryString (params) {
    return this.cleanArray(Object.keys(params).map(key => {
      if (params[key] === undefined) return ''
      return encodeURIComponent(key) + '=' +
        encodeURIComponent(params[key])
    })).join('&')
  }

  /**
   * 跳转
   * @param option
   */
  jump (option) {
    let url = option.url
    if (option.queryString) {
      url += '?'
      url += option.queryString
    }
    wx[option.method]({
      url: url,
      fail () {
        if (option.method === 'navigateTo') {
          wx.redirectTo({ url: url })
        }
      }
    })
  }

  /**
   * 商详页
   * @param {String} method 跳转方式
   * @param {Object } query
   * @param {String } query.goodsId 商品Id
   */
  goodsDetail (method = 'navigateTo', query) {
    if (!query) {
      console.error('缺少必要参数！')
      return
    }
    if (!query.goodsId) {
      console.error('缺少商品Id！')
      return
    }
    const option = {
      url: '/pages/goods/detail',
      queryString: this.toQueryString(query),
      method
    }
    this.jump(option)
  }

  /**
   * 购物车
   * @param {String} method 跳转方式
   */
  shopCart (method = 'navigateTo') {
    const option = {
      url: '/pages/shop/cart',
      method
    }
    this.jump(option)
  }

  /**
   * 个人中心
   * @param {String} method 跳转方式
   */
  userCenter (method = 'navigateTo') {
    console.log('跳转至个人中心，真实环境会跳转')
  }

  /**
   * 订单列表
   * @param {String} method 跳转方式
   * @param {Object } query
   */
  orderList (method = 'navigateTo', query) {
    console.log('跳转至订单列表，真实环境会跳转')
  }

  /**
   * 订单详情
   * @param {String} method 跳转方式
   * @param {Object } query
   */
  orderDetail (method = 'navigateTo', query) {
    if (!query) {
      console.error('缺少必要参数！')
      return
    }
    if (!query.orderNo) {
      console.error('缺少orderNo')
      return
    }

    console.log('跳转至订单详情，真实环境会跳转')
  }

  /**
   * 物流详情
   * @param {String} method 跳转方式
   * @param {Object } query
   */
  orderExpress (method = 'navigateTo', query) {
    console.log('跳转至物流详情，真实环境会跳转')
  }

  /**
   * 个人信息
   * @param {String} method 跳转方式
   */
  userSettings (method = 'navigateTo') {
    const option = {
      url: '/pages/user/member/info',
      method
    }
    this.jump(option)

    console.log('跳转至个人信息，真实环境会跳转')
  }

  /**
   * 帐号设置
   * @param {String} method 跳转方式
   */
  accountSettings (method = 'navigateTo') {
    console.log('跳转至帐号设置，真实环境会跳转')
  }

  /**
   * 我的优惠券
   * @param {String} method 跳转方式
   */
  userCouponList (method = 'navigateTo') {
    console.log('跳转至我的优惠券，真实环境会跳转')
  }

  /**
   * 积分商城
   * @param {String} method 跳转方式
   */
  pointMall (method = 'navigateTo') {
    console.log('跳转至积分商城，真实环境会跳转')
  }

  /**
   * 分销中心
   * @param {String} method 跳转方式
   */
  salesCenter (method = 'navigateTo') {
    console.log('跳转至分销中心，真实环境会跳转')
  }

  /**
   * 退款/售后列表
   * @param {String} method 跳转方式
   */
  refundList (method = 'navigateTo') {
    console.log('跳转至退款/售后列表，真实环境会跳转')
  }
}

module.exports = new Navigate()
