import requestFun from "./requestFun";
import {
  dbLoginParam,
  dbCheckHavePower,
  apiCoopIndex,
  apiDraw,
  apiQueryOptions,
  authAvatar,
  getShareUserInfo,
  getTicketStatus,
  doAssist,
  getActivityStatus,
  queryOrderId,
  userRecord,
  getTaskInfoParam,
  getShareCodeParam,
  dbLogExposure,
  dbLogClick
} from "./dbrequest";
import {
  globalData
} from "./globalData";

/** 埋点曝光 */
export const logExposure = (param) => {
  return requestFun({
    data: {
      dpm: `${globalData.appID}.110.${param}.1`,
      dcm: '202.' + globalData.projectxID + '.0.0',
      domain: `//embedlog.duiba.com.cn`,
      appId: globalData.appID
    },
    ...dbLogExposure
  })
}

/** 埋点点击 */
export const logClick = (param) => {
  return requestFun({
    data: {
      // ...param,
      dpm: `${globalData.appID}.110.${param}.1`,
      dcm: '202.' + globalData.projectxID + '.0.0',
      domain: '//embedlog.duiba.com.cn',
      appId: globalData.appID
    },
    ...dbLogClick
  })
}
// 小程序授权登陆
export const reqDbLogin = (param) => {
  console.warn("reqDbLogin")
  return requestFun({
    ...dbLoginParam,
    data: param
  })
};

//查看是否绑定手机号
export const reqDbCheckHavePower = (param) => {
  console.log(param)
  return requestFun({
    ...dbCheckHavePower,
    // url: `${dbCheckHavePower.url}`,
    data: param
  })
}

//首页
export const apiDbIndexInfo = (param) => {
  param.loginToken = globalData.loginToken
  console.log(param)
  return requestFun({
    ...apiCoopIndex,
    data: param
  })
}

//抽奖
export const apiDbDraw = (param) => {
  param.loginToken = globalData.loginToken
  console.log(param)
  return requestFun({
    ...apiDraw,
    data: param
  })
}

//转盘奖品信息
export const apiDbQueryOption = (param) => {
  console.log(param,"#$#$$$#$#$")
  param.loginToken = globalData.loginToken
  console.log(param)
  return requestFun({
    ...apiQueryOptions,
    data: param
  })
}

//授权头像
export const apiAuthAvatar = (param) => {
  param.loginToken = globalData.loginToken
  return requestFun({
    ...authAvatar,
    data: param
  })

}

//查询瓶盖码是否生效
export const apiGetTicketStatus = (param) => {
  return requestFun({
    ...getTicketStatus,
    data: param
  })
}

//查询邀请者头像昵称
export const apiGetShareUserInfo = (param) => {
  // param.loginToken = globalData.loginToken
  return requestFun({
    ...getShareUserInfo,
    data: param
  })
}

//助力
export const apiDoAssist = (param) => {
  param.loginToken = globalData.loginToken
  return requestFun({
    ...doAssist,
    data: param
  })
}

//查询活动状态
export const apiGetActivityStatus = (param) => {
  // param.loginToken = globalData.loginToken
  return requestFun({
    ...getActivityStatus,
    data: param
  })
}


//轮训查询奖品orderId
export const apiQueryOrderId = (param) => {
  param.loginToken = globalData.loginToken
  return requestFun({
    ...queryOrderId,
    data: param
  })
}


//记录用户进入数据
export const apiUserRecord = (param) => {
  return requestFun({
    ...userRecord,
    data: param
  })
}

// 任务接口
export const getTaskInfo = (param) => {
  return requestFun({
    ...getTaskInfoParam,
    data: param
  })
}

// 获取邀请码
export const getShareCode = (param) => {
  return requestFun({
    ...getShareCodeParam,
    data: param
  })
}