import { apiDbDraw, apiDbQueryOption, logClick, logExposure } from "../../utils/db_api"
import {
  globalData
} from "../../utils/db_api/globalData"
// 活动攻略
const app = getApp()
let speed = 150
let rate0 = 1
let rate1 = 1
let rate2 = 1
let round0 = 0
let round2 = 0
let round1 = 0
isTurn = false
Component({

  data: {
    list: ["top:0rpx", "top:0rpx", "top:0rpx"],
    prizeList: [
      "//yun.duiba.com.cn/aurora/assets/df01955f333b67a439987511b5f63ab930c2972c.png",
      "//yun.duiba.com.cn/aurora/assets/53b167835b33463fcafae884df1e334397c0976d.png",
      "//yun.duiba.com.cn/aurora/assets/67eca6d481505b413e61ec6ff38ade2076dc2ab0.png",
      "//yun.duiba.com.cn/aurora/assets/12fbdd91059aba8cbf27a78725cac9ff6b8d29d1.png",
      "//yun.duiba.com.cn/aurora/assets/16f3321f51561eecaaec9a15baeb9aff251530ac.png",
      "//yun.duiba.com.cn/aurora/assets/7c3a2642cbecd4a006baf4d0fc67a8fb059c303a.png"
    ],
    getprize: {}
  },

  properties: {
    drawTime: Number
  },

  attached() {
    logExposure(16)
    logExposure(17)
    isTurn = false
    this.getPrizeInfo()
    // console.log(this)
    // console.error("看看文案", this.data)
    // this.setData({
    //   lastScanTimes: globalData.indexInfo.lastScanTimes
    // })
  },


  methods: {
    async getPrizeInfo() {
      const resp = await apiDbQueryOption({ wid:globalData.wid })
      if (resp.success) {
        this.setData({
          prizeList: resp.data
        })
      }
    },
    onModalClose() {
      if(isTurn){
        return
      }
      this.triggerEvent("onModalClose", 'draw');
    },
    async onClickBtn() {
      logClick(17)
      if(isTurn){
        return
      }
      if (this.data.drawTime <= 0) {
        wx.showToast({
          title: '抽奖机会已用完，快去参与活动赢取吧～',
          icon: "none"
        })
        return
      }
      isTurn = true
      const resp = await apiDbDraw({ wid:globalData.wid })
      if (resp.success) {
        this.setData({
          getprize: resp.data
        })
        speed = 150
        rate0 = 1
        rate1 = 1
        rate2 = 1
        round0 = 0
        round2 = 0
        round1 = 0

        let item1 = 0;
        let item2 = 1;
        let item3 = 2;
        if (resp.data.prizeId == "thanks") {
          // 未中奖
          let arr = Array.from({ length: this.data.prizeList.length }, (_, index) => index)
          console.log(arr)
          for (let i = 0; i < 3; i++) {
            var _num = Math.floor(Math.random() * arr.length)
            if (i == 0) {
              item1 = arr[_num];
            } else if (i == 1) {
              item2 = arr[_num];
            } else {
              item3 = arr[_num];
            }

            arr.splice(_num, 1)
          }
        } else {
          // 中奖了
          for (let i = 0; i < this.data.prizeList.length; i++) {
            if (this.data.prizeList[i].prizeId == resp.data.prizeId) {
              item1 = item2 = item3 = i
            }
          }
        }
        this.itemMove(0, item1)
        setTimeout(() => {
          this.itemMove(1, item2)
        }, 500)
        setTimeout(() => {
          this.itemMove(2, item3)
        }, 1000)
      }else{
        isTurn = false
      }

    },

    itemMove(id, index) {

      let roundNum = 0
      if (id == 0) {
        roundNum = round0
      } else if (id == 1) {
        roundNum = round1
      } else if (id == 2) {
        roundNum = round2
      }
      let rateList = [rate0, rate1, rate2]
      if (roundNum == 3) {
        rateList[id] -= 0.05
        if (rateList[id] < 0.1) {
          rateList[id] = 0.1
        }
        let hightTop = Number(this.data.list[id].replace(/[^\d.-]/g, "")) - speed * rateList[id]
        let hightLab = "top:" + hightTop + "rpx"
        if (hightTop <= -248 * index) {
          hightLab = "top:" + (-248 * index) + "rpx"
          let listInfo = this.data.list
          listInfo[id] = hightLab
          // console.log("listInfo3", id, listInfo)
          setTimeout(() => {
            this.setData({
              list: listInfo
            })
          }, 100)

          if (id == 2) {
            setTimeout(() => {
              this.triggerEvent("onModalClose", 'draw');

              if (this.data.getprize.prizeId != "thanks") {
                this.triggerEvent("onModalPrize", { ...this.data.getprize })
              } else {
                this.triggerEvent("onModalNoPrize")
              }
              isTurn = false
            }, 1000)

          }
        } else {
          let listInfo = this.data.list
          listInfo[id] = hightLab
          // console.log("listInfo2", id, listInfo)
          this.setData({
            list: listInfo
          }, () => {
            setTimeout(() => {
              this.itemMove(id, index)
            }, 20)
          })
          // window.requestAnimationFrame(() => this.itemMove(id, index))

        }
      } else {
        let hightTop = Number(this.data.list[id].replace(/[^\d.-]/g, "")) - speed
        // console.log(hightTop, Number(this.data.list[id].replace(/[^\d.-]/g, "")))
        let hightLab = "top:" + hightTop + "rpx"
        // console.log(hightTop)
        if (hightTop <= -248 * (this.data.prizeList.length)) {
          if (id == 0) {
            round0++
          } else if (id == 1) {
            round1++
          } else if (id == 2) {
            round2++
          }
          // this["round" + id]++
          hightLab = "top:0rpx"

        }
        let listInfo = this.data.list
        listInfo[id] = hightLab
        // console.log("listInfo1", id, listInfo)
        this.setData({
          list: listInfo
        }, () => {
          setTimeout(() => {
            this.itemMove(id, index)
          }, 20)
        })
        // window.requestAnimationFrame(() => this.itemMove(id, index))

      }



    }
  }

})