exports.ids = ["weimob-cloud-commons"];
exports.modules = {

/***/ "./src/packages/wm-cloud-db_index/utils/db_api/dbrequest.js":
/*!******************************************************************!*\
  !*** ./src/packages/wm-cloud-db_index/utils/db_api/dbrequest.js ***!
  \******************************************************************/
/*! exports provided: dbDomain, mdDomain, dbLogExposure, dbLogClick, dbLoginParam, dbCheckHavePower, apiCoopIndex, apiDraw, apiQueryOptions, authAvatar, getTicketStatus, getShareUserInfo, doAssist, getActivityStatus, queryOrderId, userRecord, getTaskInfoParam, getShareCodeParam */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "dbDomain", function() { return dbDomain; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "mdDomain", function() { return mdDomain; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "dbLogExposure", function() { return dbLogExposure; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "dbLogClick", function() { return dbLogClick; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "dbLoginParam", function() { return dbLoginParam; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "dbCheckHavePower", function() { return dbCheckHavePower; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "apiCoopIndex", function() { return apiCoopIndex; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "apiDraw", function() { return apiDraw; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "apiQueryOptions", function() { return apiQueryOptions; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "authAvatar", function() { return authAvatar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getTicketStatus", function() { return getTicketStatus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getShareUserInfo", function() { return getShareUserInfo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "doAssist", function() { return doAssist; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getActivityStatus", function() { return getActivityStatus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "queryOrderId", function() { return queryOrderId; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "userRecord", function() { return userRecord; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getTaskInfoParam", function() { return getTaskInfoParam; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getShareCodeParam", function() { return getShareCodeParam; });
// 线上测试 pre  线上正式online
// TODO 上线前检查
const app = getApp();
const __env__ = 'test';
const dbDomains = {
  'online': "https://95721.activity-18.m.duiba.com.cn",
  'pre': "https://activity-pre.m.duiba.com.cn",
  'test': "https://activity.m.duibatest.com.cn"
};

// const dbDomainPaths = {
//   'online': dbDomains['online'] + "/projectx/p764e268d",
//   'pre': dbDomains['pre'] + "/projectx/p764e268d",
//   'test': dbDomains['test'] + "/projectx/pfebb155c"
// }

// /**小程序接口 */
const dbDomain = dbDomains[__env__];
// /**活动接口 */
// export const apiDbDomain = dbDomainPaths[__env__]
const exposurePaths = {
  'online': 'https://embedlog.duiba.com.cn/exposure/standard',
  'pre': 'https://embedlog.duiba.com.cn/exposure/standard',
  'test': 'https://embedlog.duibatest.com.cn/exposure/standard',
  'dev': 'https://embedlog.duibadev.com.cn/exposure/standard'
};
const mdDomain = exposurePaths[__env__];
const dbLogExposure = {
  url: mdDomain
};

/** 点击埋点 */
const dbLogClick = {
  url: dbDomain + '/log/click'
};
// 小程序授权登陆
const dbLoginParam = {
  url: "/weimocloud/wechat/autoLogin",
  //dbDomain +
  method: "POST",
  header: {}
};

// 验证用户是否授权过
const dbCheckHavePower = {
  url: "/weimocloud/wechat/loginCheck",
  //dbDomain +
  method: "POST",
  header: {}
};

/** 活动首页*/
const apiCoopIndex = {
  url: "/duiba/projectx/index",
  //apiDbDomain +
  header: {},
  method: "GET"
};

/** 转盘抽奖*/
const apiDraw = {
  url: "/duiba/projectx/draw",
  //apiDbDomain +
  header: {},
  method: "GET"
};

// 转盘奖品信息
const apiQueryOptions = {
  url: "/duiba/projectx/queryOptions",
  method: "GET",
  header: {}
};

//保存头像昵称
const authAvatar = {
  url: "/weimocloud/projectx/authAvatar",
  method: "GET",
  header: {}
};

// weimocloud/projectx/getTicketStatus?ticket=xx&qrcodeSign=xxx

//查询瓶盖码有没有过期
const getTicketStatus = {
  url: "/weimocloud/projectx/getTicketStatus",
  method: "GET",
  header: {}
};

//获取邀请者头像昵称
const getShareUserInfo = {
  url: "/weimocloud/projectx/getShareUserInfo",
  method: "GET",
  header: {}
};

//助力
const doAssist = {
  url: "/weimocloud/projectx/doAssist",
  method: "GET",
  header: {}
};

//获取活动状态
const getActivityStatus = {
  url: "/weimocloud/projectx/getActivityStatus",
  method: "GET",
  header: {}
};

//轮训查询奖品orderId
const queryOrderId = {
  url: "/weimocloud/projectx/getOrderId",
  method: "GET",
  header: {}
};
const userRecord = {
  url: "/weimocloud/projectx/userRecord",
  method: "GET",
  header: {}
};

// 任务接口
const getTaskInfoParam = {
  url: "/weimocloud/projectx/taskInfo",
  method: "GET",
  header: {}
};

// 获取邀请码
const getShareCodeParam = {
  url: "/weimocloud/projectx/getShareCode",
  method: "GET",
  header: {}
};

/***/ }),

/***/ "./src/packages/wm-cloud-db_index/utils/db_api/globalData.js":
/*!*******************************************************************!*\
  !*** ./src/packages/wm-cloud-db_index/utils/db_api/globalData.js ***!
  \*******************************************************************/
/*! exports provided: globalData, awardUrl, rankUrl, chanllageUrl, shopUrl, exchangeUrl, getUrlParam */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "globalData", function() { return globalData; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "awardUrl", function() { return awardUrl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "rankUrl", function() { return rankUrl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "chanllageUrl", function() { return chanllageUrl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "shopUrl", function() { return shopUrl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "exchangeUrl", function() { return exchangeUrl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getUrlParam", function() { return getUrlParam; });
// // 线上测试
// export const preEnv = "https://95721.activity-18.m.duiba.com.cn/projectx/p03805f35/index.html?appID=95721"

// export const prodEnv = "https://95721.activity-18.m.duiba.com.cn/projectx/pf892b6a1/index.html?appID=95721"

const globalData = {
  loginToken: "",
  indexInfo: {},
  wid: "",
  projectxID: "1",
  appID: "1"
};
//正式项目 pc98b8da4
//线上测试 pb4c53264

const awardUrl = "https://duiba.ioutu.cn/projectx/pc98b8da4/myPrize.html?appID=96109";
const rankUrl = "https://duiba.ioutu.cn/projectx/pc98b8da4/rank.html?appID=96109";
const chanllageUrl = "https://duiba.ioutu.cn/projectx/pc98b8da4/index.html?appID=96109";
const shopUrl = "/cms_design/index?productInstanceId=13068633342&vid=0&pageid=57840295342";
const exchangeUrl = "/cms_design/design?productInstanceId=13068633342&vid=0&pageid=58011845342";
function getUrlParam(name, search) {
  let matched = search.split('?')[1].match(new RegExp('(^|&)' + name + '=([^&]*)(&|$)', 'i'));
  return search.length ? matched && matched[2] : null;
}

/***/ }),

/***/ "./src/packages/wm-cloud-db_index/utils/db_api/index.js":
/*!**************************************************************!*\
  !*** ./src/packages/wm-cloud-db_index/utils/db_api/index.js ***!
  \**************************************************************/
/*! exports provided: logExposure, logClick, reqDbLogin, reqDbCheckHavePower, apiDbIndexInfo, apiDbDraw, apiDbQueryOption, apiAuthAvatar, apiGetTicketStatus, apiGetShareUserInfo, apiDoAssist, apiGetActivityStatus, apiQueryOrderId, apiUserRecord, getTaskInfo, getShareCode */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "logExposure", function() { return logExposure; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "logClick", function() { return logClick; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "reqDbLogin", function() { return reqDbLogin; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "reqDbCheckHavePower", function() { return reqDbCheckHavePower; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "apiDbIndexInfo", function() { return apiDbIndexInfo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "apiDbDraw", function() { return apiDbDraw; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "apiDbQueryOption", function() { return apiDbQueryOption; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "apiAuthAvatar", function() { return apiAuthAvatar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "apiGetTicketStatus", function() { return apiGetTicketStatus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "apiGetShareUserInfo", function() { return apiGetShareUserInfo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "apiDoAssist", function() { return apiDoAssist; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "apiGetActivityStatus", function() { return apiGetActivityStatus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "apiQueryOrderId", function() { return apiQueryOrderId; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "apiUserRecord", function() { return apiUserRecord; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getTaskInfo", function() { return getTaskInfo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getShareCode", function() { return getShareCode; });
/* harmony import */ var _requestFun__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./requestFun */ "./src/packages/wm-cloud-db_index/utils/db_api/requestFun.js");
/* harmony import */ var _dbrequest__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./dbrequest */ "./src/packages/wm-cloud-db_index/utils/db_api/dbrequest.js");
/* harmony import */ var _globalData__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./globalData */ "./src/packages/wm-cloud-db_index/utils/db_api/globalData.js");




/** 埋点曝光 */
const logExposure = param => {
  return Object(_requestFun__WEBPACK_IMPORTED_MODULE_0__["default"])({
    data: {
      dpm: `${_globalData__WEBPACK_IMPORTED_MODULE_2__["globalData"].appID}.110.${param}.1`,
      dcm: '202.' + _globalData__WEBPACK_IMPORTED_MODULE_2__["globalData"].projectxID + '.0.0',
      domain: `//embedlog.duiba.com.cn`,
      appId: _globalData__WEBPACK_IMPORTED_MODULE_2__["globalData"].appID
    },
    ..._dbrequest__WEBPACK_IMPORTED_MODULE_1__["dbLogExposure"]
  });
};

/** 埋点点击 */
const logClick = param => {
  return Object(_requestFun__WEBPACK_IMPORTED_MODULE_0__["default"])({
    data: {
      // ...param,
      dpm: `${_globalData__WEBPACK_IMPORTED_MODULE_2__["globalData"].appID}.110.${param}.1`,
      dcm: '202.' + _globalData__WEBPACK_IMPORTED_MODULE_2__["globalData"].projectxID + '.0.0',
      domain: '//embedlog.duiba.com.cn',
      appId: _globalData__WEBPACK_IMPORTED_MODULE_2__["globalData"].appID
    },
    ..._dbrequest__WEBPACK_IMPORTED_MODULE_1__["dbLogClick"]
  });
};
// 小程序授权登陆
const reqDbLogin = param => {
  console.warn("reqDbLogin");
  return Object(_requestFun__WEBPACK_IMPORTED_MODULE_0__["default"])({
    ..._dbrequest__WEBPACK_IMPORTED_MODULE_1__["dbLoginParam"],
    data: param
  });
};

//查看是否绑定手机号
const reqDbCheckHavePower = param => {
  console.log(param);
  return Object(_requestFun__WEBPACK_IMPORTED_MODULE_0__["default"])({
    ..._dbrequest__WEBPACK_IMPORTED_MODULE_1__["dbCheckHavePower"],
    // url: `${dbCheckHavePower.url}`,
    data: param
  });
};

//首页
const apiDbIndexInfo = param => {
  param.loginToken = _globalData__WEBPACK_IMPORTED_MODULE_2__["globalData"].loginToken;
  console.log(param);
  return Object(_requestFun__WEBPACK_IMPORTED_MODULE_0__["default"])({
    ..._dbrequest__WEBPACK_IMPORTED_MODULE_1__["apiCoopIndex"],
    data: param
  });
};

//抽奖
const apiDbDraw = param => {
  param.loginToken = _globalData__WEBPACK_IMPORTED_MODULE_2__["globalData"].loginToken;
  console.log(param);
  return Object(_requestFun__WEBPACK_IMPORTED_MODULE_0__["default"])({
    ..._dbrequest__WEBPACK_IMPORTED_MODULE_1__["apiDraw"],
    data: param
  });
};

//转盘奖品信息
const apiDbQueryOption = param => {
  console.log(param, "#$#$$$#$#$");
  param.loginToken = _globalData__WEBPACK_IMPORTED_MODULE_2__["globalData"].loginToken;
  console.log(param);
  return Object(_requestFun__WEBPACK_IMPORTED_MODULE_0__["default"])({
    ..._dbrequest__WEBPACK_IMPORTED_MODULE_1__["apiQueryOptions"],
    data: param
  });
};

//授权头像
const apiAuthAvatar = param => {
  param.loginToken = _globalData__WEBPACK_IMPORTED_MODULE_2__["globalData"].loginToken;
  return Object(_requestFun__WEBPACK_IMPORTED_MODULE_0__["default"])({
    ..._dbrequest__WEBPACK_IMPORTED_MODULE_1__["authAvatar"],
    data: param
  });
};

//查询瓶盖码是否生效
const apiGetTicketStatus = param => {
  return Object(_requestFun__WEBPACK_IMPORTED_MODULE_0__["default"])({
    ..._dbrequest__WEBPACK_IMPORTED_MODULE_1__["getTicketStatus"],
    data: param
  });
};

//查询邀请者头像昵称
const apiGetShareUserInfo = param => {
  // param.loginToken = globalData.loginToken
  return Object(_requestFun__WEBPACK_IMPORTED_MODULE_0__["default"])({
    ..._dbrequest__WEBPACK_IMPORTED_MODULE_1__["getShareUserInfo"],
    data: param
  });
};

//助力
const apiDoAssist = param => {
  param.loginToken = _globalData__WEBPACK_IMPORTED_MODULE_2__["globalData"].loginToken;
  return Object(_requestFun__WEBPACK_IMPORTED_MODULE_0__["default"])({
    ..._dbrequest__WEBPACK_IMPORTED_MODULE_1__["doAssist"],
    data: param
  });
};

//查询活动状态
const apiGetActivityStatus = param => {
  // param.loginToken = globalData.loginToken
  return Object(_requestFun__WEBPACK_IMPORTED_MODULE_0__["default"])({
    ..._dbrequest__WEBPACK_IMPORTED_MODULE_1__["getActivityStatus"],
    data: param
  });
};

//轮训查询奖品orderId
const apiQueryOrderId = param => {
  param.loginToken = _globalData__WEBPACK_IMPORTED_MODULE_2__["globalData"].loginToken;
  return Object(_requestFun__WEBPACK_IMPORTED_MODULE_0__["default"])({
    ..._dbrequest__WEBPACK_IMPORTED_MODULE_1__["queryOrderId"],
    data: param
  });
};

//记录用户进入数据
const apiUserRecord = param => {
  return Object(_requestFun__WEBPACK_IMPORTED_MODULE_0__["default"])({
    ..._dbrequest__WEBPACK_IMPORTED_MODULE_1__["userRecord"],
    data: param
  });
};

// 任务接口
const getTaskInfo = param => {
  return Object(_requestFun__WEBPACK_IMPORTED_MODULE_0__["default"])({
    ..._dbrequest__WEBPACK_IMPORTED_MODULE_1__["getTaskInfoParam"],
    data: param
  });
};

// 获取邀请码
const getShareCode = param => {
  return Object(_requestFun__WEBPACK_IMPORTED_MODULE_0__["default"])({
    ..._dbrequest__WEBPACK_IMPORTED_MODULE_1__["getShareCodeParam"],
    data: param
  });
};

/***/ }),

/***/ "./src/packages/wm-cloud-db_index/utils/db_api/requestFun.js":
/*!*******************************************************************!*\
  !*** ./src/packages/wm-cloud-db_index/utils/db_api/requestFun.js ***!
  \*******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _globalData__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./globalData */ "./src/packages/wm-cloud-db_index/utils/db_api/globalData.js");

const requestFun = async dataSouce => {
  // wx.showLoading({
  //   mask: true
  // })
  console.log(dataSouce, "dataSouce");
  return await new Promise((resolve, reject) => {
    getApp().getSdk().request({
      url: dataSouce.url,
      // 接口名称相对地址
      data: {
        ...dataSouce.data
      },
      // 接口所需数据
      requestOption: {
        header: {
          ...dataSouce.header,
          "cloud-app-id": "612072719085-yxh-login" // 开发者接口所在容器应用的环境域名前缀。配置错误会导致HTTP请求404。
        },
        method: dataSouce.method
      }
    }).then(res => {
      if (res.code == '90002') {
        /**token失效，重新登陆 */
        // await login(globalData.wid)
        wx.showToast({
          title: '获取数据失败，请重新进入吧~',
          icon: "none"
        });
      }
      console.warn('收到接口返回值:' + dataSouce.url, res);
      resolve(res);
    });
  });
};
/* harmony default export */ __webpack_exports__["default"] = (requestFun);
const login = async wid => {
  await new Promise(r => {
    wx.login({
      success: ress => {
        reqDbLogin({
          code: ress.code,
          wid
        }).then(respp => {
          if (respp) {
            _globalData__WEBPACK_IMPORTED_MODULE_0__["globalData"].loginToken = encodeURIComponent(respp.data.loginToken);
            r(1);
          }
        });
      }
    });
  });
};

/***/ })

};;