'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './creditspage.less';
import { dateFormatter } from '@src/utils/utils';

@observer
class Creditspage extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      list: [
        {
          name: "dsfifnbsikd",
          time: "1714307625657",
          num: 20
        },
        {
          name: "红烧鸡腿戒烟戒酒你发过吗工卡突然",
          time: "1714307625657",
          num: -20
        },
        {
          name: "dsfifnbsikd",
          time: "1714307625657",
          num: 20
        },
        {
          name: "dsfifnbsikd",
          time: "1714307625657",
          num: 20
        },
        {
          name: "dsfifnbsikd",
          time: "1714307625657",
          num: 20
        },
        {
          name: "dsfifnbsikd",
          time: "1714307625657",
          num: 20
        },
        {
          name: "dsfifnbsikd",
          time: "1714307625657",
          num: 20
        },
        {
          name: "SRG虽然国华人寿微人大刚发搭嘎放大后干哈特冶突然而饿死防守打法",
          time: "1714307625657",
          num: 20
        },
        {
          name: "dsfifnbsikd",
          time: "1714307625657",
          num: 20
        },
        {
          name: "dsfifnbsikd",
          time: "1714307625657",
          num: 20
        },
        {
          name: "dsfifnbsikd",
          time: "1714307625657",
          num: 20
        },
        {
          name: "三个人撒个大货车下半年有可燃几哈虽然高S",
          time: "1714307625657",
          num: 20
        },
        {
          name: "哭开头语看见他巨化股份对吧v",
          time: "1714307625657",
          num: 20
        },
        {
          name: "双法防",
          time: "1714307625657",
          num: 20
        },
        {
          name: "防护服规划法规",
          time: "1714307625657",
          num: 20
        },
        {
          name: "kjhlku",
          time: "1714307625657",
          num: 20
        },
        {
          name: "dsfsds",
          time: "1714307625657",
          num: 20
        },
        {
          name: "hfgdhfd",
          time: "1714307625657",
          num: 20
        }
      ]
    }
  }
  render() {
    return (
      <div className='pagebox'>
        <div className="creditspage modal_center">
          <span className="bg"></span>
          <span className="back"></span>
          <span className="creditsbg"></span>
          <span className="credits">124432</span>
          <div className="showlist" style={{ height: `${(1106 - 20 - (1624 - document.body.clientHeight * 750 / document.body.clientWidth) / 2) / 100}rem` }}>
            {
              this.state.list?.map((item,index) => {
                return (
                  <div className="item" key={"credits"+index}>
                    <span className="itemtime">{dateFormatter(item.time,'yyyy.MM.dd hh:mm')} </span>
                    <span className="itemname">{item.name}</span>
                    {
                      item.num>0?<span className="addshow">+{item.num}</span>
                      :<span className="cutshow">{item.num}</span>
                    }
                    <span className="line"></span>
                  </div>
                )
              })
            }

          </div>
        </div>
      </div>
    );
  }
}
export default Creditspage;
