'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './prizepage.less';
import { callApi } from '@spark/api-base';
import { _throttle } from '@src/utils/utils';

@observer
class Prizepage extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      prizeList: []
    }
  }
  componentDidMount() {
    this.getPrizeInfo();
  }
  /** 获取奖品信息 */
  getPrizeInfo = async () => {
    console.log("%$^$%^$^%^$%^")
    const includeCrecord = false; //包含积分商城的记录
    const includeCredits = false; //包含积分
    const excludeSp = false; //排除道具
    let customFilter; //自定义过滤方法

    const ps = [];
    const params = {};
    if (includeCredits) {
      params.credits = "1";
    }
    ps.push(callApi("records.query", params));

    if (includeCrecord) {
      ps.push(callApi("/crecord/getrecord", { page: 1 }, undefined, undefined, false));
    }

    const [recordsResp, oldRecordsResp] = await Promise.all(ps);
    let records = [];

    for (let item of recordsResp) {
      const {
        extra: { type },
      } = item;
      if (excludeSp && type === 1) {
        continue;
      }
      if (customFilter && !customFilter(item)) {
        continue;
      }
      const {
        extra: { name, icon },
        id,
        prizeId,
        gmtCreate,
      } = item;
      records.push({
        id,
        name,
        icon,
        prizeId,
        gmtCreate,
        data: item,
      });
    }

    if (oldRecordsResp) {
      for (let item of oldRecordsResp?.records || []) {
        if (customFilter && !customFilter(item)) {
          continue;
        }
        const { title, url, img } = item;
        records.push({
          url,
          name: title,
          icon: img,
          data: item,
        });
      }
    }
    records = records.filter((item) => {
      // console.log(item?.prizeId, item?.prizeId?.startsWith("sp_exclusive_red"), !item?.prizeId?.startsWith("sp_"));
      return !item?.prizeId?.startsWith("sp_");
    });
    this.setState({
      prizeList: records || [],
    });
  };

  /** 跳转兑吧奖品 */
  navigateToPrize = (item) => {
    return _throttle(() => {
      if (!!item?.url) {
        location.href = item?.url;
      } else {
        location.href = `/aaw/projectx/takePrize?projectOrderNo=${item.id}`;
      }
    });
  };
  render() {
    return (
      <div className='pagebox'>
        <div className="prizepage modal_center">
          <span className="bg"></span>
          <span className="back"></span>
          <div className="prizelist" style={{ height: `${(1321 - 20 - (1624 - document.body.clientHeight * 750 / document.body.clientWidth) / 2) / 100}rem` }}>
            {
              this.state.prizeList?.map((item, index) => {
                return (
                  <div className="item" key={"prize" + index} onClick={this.navigateToPrize}>
                    <span className="itembg"></span>
                    <span className="gobtn"></span>
                    <span className="prizename">{item?.name}</span>
                    <span className="prizebg">
                      <img style={{width:"100%",height:"100%",borderRadius:"10px"}} src={item?.icon}></img>
                    </span>
                  </div>
                )
              })
            }

          </div>
        </div>
      </div>
    );
  }
}
export default Prizepage;
