/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.view.View;
import com.facebook.react.bridge.BaseJavaModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.touch.JSResponderHandler;
import com.facebook.react.touch.ReactInterceptingViewGroup;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewManagerPropertyUpdater;
import com.facebook.react.uimanager.annotations.ReactPropertyHolder;
import java.util.Map;
import javax.annotation.Nullable;

@ReactPropertyHolder
public abstract class ViewManager<T extends View, C extends ReactShadowNode>
extends BaseJavaModule {
    public final void updateProperties(T viewToUpdate, ReactStylesDiffMap props) {
        ViewManagerPropertyUpdater.updateProps(this, viewToUpdate, props);
        this.onAfterUpdateTransaction(viewToUpdate);
    }

    public final T createView(ThemedReactContext reactContext, JSResponderHandler jsResponderHandler) {
        T view = this.createViewInstance(reactContext);
        this.addEventEmitters(reactContext, view);
        if (view instanceof ReactInterceptingViewGroup) {
            ((ReactInterceptingViewGroup)view).setOnInterceptTouchEventListener(jsResponderHandler);
        }
        return view;
    }

    @Override
    public abstract String getName();

    public C createShadowNodeInstance() {
        throw new RuntimeException("ViewManager subclasses must implement createShadowNodeInstance()");
    }

    public C createShadowNodeInstance(ReactApplicationContext context) {
        return this.createShadowNodeInstance();
    }

    public abstract Class<? extends C> getShadowNodeClass();

    protected abstract T createViewInstance(ThemedReactContext var1);

    public void onDropViewInstance(T view) {
    }

    protected void addEventEmitters(ThemedReactContext reactContext, T view) {
    }

    protected void onAfterUpdateTransaction(T view) {
    }

    public abstract void updateExtraData(T var1, Object var2);

    public void receiveCommand(T root, int commandId, @Nullable ReadableArray args) {
    }

    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return null;
    }

    @Nullable
    public Map<String, Object> getExportedCustomBubblingEventTypeConstants() {
        return null;
    }

    @Nullable
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        return null;
    }

    @Nullable
    public Map<String, Object> getExportedViewConstants() {
        return null;
    }

    public Map<String, String> getNativeProps() {
        return ViewManagerPropertyUpdater.getNativeProps(this.getClass(), this.getShadowNodeClass());
    }
}

