/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.graphics.Bitmap;
import android.os.Build;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Throwables;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.common.TooManyBitmapsException;
import com.facebook.imagepipeline.nativecode.Bitmaps;
import com.facebook.imageutils.BitmapUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

public class BitmapCounter {
    @GuardedBy(value="this")
    private int mCount;
    @GuardedBy(value="this")
    private long mSize;
    private final int mMaxCount;
    private final int mMaxSize;
    private final ResourceReleaser<Bitmap> mUnpooledBitmapsReleaser;

    public BitmapCounter(int maxCount, int maxSize) {
        Preconditions.checkArgument((maxCount > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0);
        this.mMaxCount = maxCount;
        this.mMaxSize = maxSize;
        this.mUnpooledBitmapsReleaser = new ResourceReleaser<Bitmap>(){

            public void release(Bitmap value) {
                try {
                    BitmapCounter.this.decrease(value);
                }
                finally {
                    value.recycle();
                }
            }
        };
    }

    public synchronized boolean increase(Bitmap bitmap) {
        int bitmapSize = BitmapUtil.getSizeInBytes((Bitmap)bitmap);
        if (this.mCount >= this.mMaxCount || this.mSize + (long)bitmapSize > (long)this.mMaxSize) {
            return false;
        }
        ++this.mCount;
        this.mSize += (long)bitmapSize;
        return true;
    }

    public synchronized void decrease(Bitmap bitmap) {
        int bitmapSize = BitmapUtil.getSizeInBytes((Bitmap)bitmap);
        Preconditions.checkArgument((this.mCount > 0 ? 1 : 0) != 0, (Object)"No bitmaps registered.");
        Preconditions.checkArgument(((long)bitmapSize <= this.mSize ? 1 : 0) != 0, (String)"Bitmap size bigger than the total registered size: %d, %d", (Object[])new Object[]{bitmapSize, this.mSize});
        this.mSize -= (long)bitmapSize;
        --this.mCount;
    }

    public synchronized int getCount() {
        return this.mCount;
    }

    public synchronized long getSize() {
        return this.mSize;
    }

    public ResourceReleaser<Bitmap> getReleaser() {
        return this.mUnpooledBitmapsReleaser;
    }

    public List<CloseableReference<Bitmap>> associateBitmapsWithBitmapCounter(List<Bitmap> bitmaps) {
        int countedBitmaps;
        try {
            for (countedBitmaps = 0; countedBitmaps < bitmaps.size(); ++countedBitmaps) {
                Bitmap bitmap = bitmaps.get(countedBitmaps);
                if (Build.VERSION.SDK_INT < 21) {
                    Bitmaps.pinBitmap(bitmap);
                }
                if (this.increase(bitmap)) continue;
                throw new TooManyBitmapsException();
            }
            ArrayList<CloseableReference<Bitmap>> ret = new ArrayList<CloseableReference<Bitmap>>(bitmaps.size());
            for (Bitmap bitmap : bitmaps) {
                ret.add((CloseableReference<Bitmap>)CloseableReference.of((Object)bitmap, this.mUnpooledBitmapsReleaser));
            }
            return ret;
        }
        catch (Exception exception) {
            if (bitmaps != null) {
                for (Bitmap bitmap : bitmaps) {
                    if (countedBitmaps-- > 0) {
                        this.decrease(bitmap);
                    }
                    bitmap.recycle();
                }
            }
            throw Throwables.propagate((Throwable)exception);
        }
    }
}

