/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.soloader;

import android.util.Log;
import com.facebook.soloader.SoLoader;
import java.util.List;

public abstract class NativeLibrary {
    private static final String TAG = NativeLibrary.class.getName();
    private final Object mLock = new Object();
    private List<String> mLibraryNames;
    private Boolean mLoadLibraries = true;
    private boolean mLibrariesLoaded = false;
    private volatile UnsatisfiedLinkError mLinkError = null;

    protected NativeLibrary(List<String> libraryNames) {
        this.mLibraryNames = libraryNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadLibraries() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mLoadLibraries.booleanValue()) {
                return this.mLibrariesLoaded;
            }
            try {
                for (String name : this.mLibraryNames) {
                    SoLoader.loadLibrary(name);
                }
                this.initialNativeCheck();
                this.mLibrariesLoaded = true;
                this.mLibraryNames = null;
            }
            catch (UnsatisfiedLinkError error) {
                Log.e((String)TAG, (String)"Failed to load native lib: ", (Throwable)error);
                this.mLinkError = error;
                this.mLibrariesLoaded = false;
            }
            this.mLoadLibraries = false;
            return this.mLibrariesLoaded;
        }
    }

    public void ensureLoaded() throws UnsatisfiedLinkError {
        if (!this.loadLibraries()) {
            throw this.mLinkError;
        }
    }

    protected void initialNativeCheck() throws UnsatisfiedLinkError {
    }

    public UnsatisfiedLinkError getError() {
        return this.mLinkError;
    }
}

