/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.logging.FLog;
import com.facebook.imagepipeline.producers.Consumer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class BaseConsumer<T>
implements Consumer<T> {
    private boolean mIsFinished = false;

    @Override
    public synchronized void onNewResult(@Nullable T newResult, boolean isLast) {
        if (this.mIsFinished) {
            return;
        }
        this.mIsFinished = isLast;
        try {
            this.onNewResultImpl(newResult, isLast);
        }
        catch (Exception e) {
            this.onUnhandledException(e);
        }
    }

    @Override
    public synchronized void onFailure(Throwable t) {
        if (this.mIsFinished) {
            return;
        }
        this.mIsFinished = true;
        try {
            this.onFailureImpl(t);
        }
        catch (Exception e) {
            this.onUnhandledException(e);
        }
    }

    @Override
    public synchronized void onCancellation() {
        if (this.mIsFinished) {
            return;
        }
        this.mIsFinished = true;
        try {
            this.onCancellationImpl();
        }
        catch (Exception e) {
            this.onUnhandledException(e);
        }
    }

    @Override
    public synchronized void onProgressUpdate(float progress) {
        if (this.mIsFinished) {
            return;
        }
        try {
            this.onProgressUpdateImpl(progress);
        }
        catch (Exception e) {
            this.onUnhandledException(e);
        }
    }

    protected abstract void onNewResultImpl(T var1, boolean var2);

    protected abstract void onFailureImpl(Throwable var1);

    protected abstract void onCancellationImpl();

    protected void onProgressUpdateImpl(float progress) {
    }

    protected void onUnhandledException(Exception e) {
        FLog.wtf(this.getClass(), (String)"unhandled exception", (Throwable)e);
    }
}

