/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.util.Pair;
import com.facebook.common.internal.Preconditions;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;

public class ThrottlingProducer<T>
implements Producer<T> {
    public static final String PRODUCER_NAME = "ThrottlingProducer";
    private final Producer<T> mInputProducer;
    private final int mMaxSimultaneousRequests;
    @GuardedBy(value="this")
    private int mNumCurrentRequests;
    @GuardedBy(value="this")
    private final ConcurrentLinkedQueue<Pair<Consumer<T>, ProducerContext>> mPendingRequests;
    private final Executor mExecutor;

    public ThrottlingProducer(int maxSimultaneousRequests, Executor executor, Producer<T> inputProducer) {
        this.mMaxSimultaneousRequests = maxSimultaneousRequests;
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.mInputProducer = (Producer)Preconditions.checkNotNull(inputProducer);
        this.mPendingRequests = new ConcurrentLinkedQueue();
        this.mNumCurrentRequests = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void produceResults(Consumer<T> consumer, ProducerContext producerContext) {
        boolean delayRequest;
        ProducerListener producerListener = producerContext.getListener();
        producerListener.onProducerStart(producerContext.getId(), PRODUCER_NAME);
        ThrottlingProducer throttlingProducer = this;
        synchronized (throttlingProducer) {
            if (this.mNumCurrentRequests >= this.mMaxSimultaneousRequests) {
                this.mPendingRequests.add(Pair.create(consumer, (Object)producerContext));
                delayRequest = true;
            } else {
                ++this.mNumCurrentRequests;
                delayRequest = false;
            }
        }
        if (!delayRequest) {
            this.produceResultsInternal(consumer, producerContext);
        }
    }

    void produceResultsInternal(Consumer<T> consumer, ProducerContext producerContext) {
        ProducerListener producerListener = producerContext.getListener();
        producerListener.onProducerFinishWithSuccess(producerContext.getId(), PRODUCER_NAME, null);
        this.mInputProducer.produceResults(new ThrottlerConsumer(consumer), producerContext);
    }

    private class ThrottlerConsumer
    extends DelegatingConsumer<T, T> {
        private ThrottlerConsumer(Consumer<T> consumer) {
            super(consumer);
        }

        @Override
        protected void onNewResultImpl(T newResult, boolean isLast) {
            this.getConsumer().onNewResult(newResult, isLast);
            if (isLast) {
                this.onRequestFinished();
            }
        }

        @Override
        protected void onFailureImpl(Throwable t) {
            this.getConsumer().onFailure(t);
            this.onRequestFinished();
        }

        @Override
        protected void onCancellationImpl() {
            this.getConsumer().onCancellation();
            this.onRequestFinished();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onRequestFinished() {
            Pair nextRequestPair;
            ThrottlingProducer throttlingProducer = ThrottlingProducer.this;
            synchronized (throttlingProducer) {
                nextRequestPair = (Pair)ThrottlingProducer.this.mPendingRequests.poll();
                if (nextRequestPair == null) {
                    ThrottlingProducer.this.mNumCurrentRequests--;
                }
            }
            if (nextRequestPair != null) {
                ThrottlingProducer.this.mExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ThrottlingProducer.this.produceResultsInternal((Consumer)nextRequestPair.first, (ProducerContext)nextRequestPair.second);
                    }
                });
            }
        }
    }
}

