/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.datasource;

import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.AbstractDataSource;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SettableDataSource<T>
extends AbstractDataSource<CloseableReference<T>> {
    public static <V> SettableDataSource<V> create() {
        return new SettableDataSource();
    }

    private SettableDataSource() {
    }

    public boolean set(@Nullable CloseableReference<T> valueRef) {
        CloseableReference clonedRef = CloseableReference.cloneOrNull(valueRef);
        return super.setResult((Object)clonedRef, true);
    }

    public boolean setException(Throwable throwable) {
        return super.setFailure(throwable);
    }

    public boolean setProgress(float progress) {
        return super.setProgress(progress);
    }

    @Nullable
    public CloseableReference<T> getResult() {
        return CloseableReference.cloneOrNull((CloseableReference)((CloseableReference)super.getResult()));
    }

    protected void closeResult(@Nullable CloseableReference<T> result) {
        CloseableReference.closeSafely(result);
    }
}

