/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;

final class ElementsList<E> {
    private final ArrayList<Scope> mScopesStack = new ArrayList();
    private final ArrayDeque<E> mElements = new ArrayDeque();
    private final E[] mEmptyArray;
    private Scope mCurrentScope = null;
    private int mScopeIndex = 0;

    public ElementsList(E[] emptyArray) {
        this.mEmptyArray = emptyArray;
        this.mScopesStack.add(this.mCurrentScope);
    }

    public void start(Object[] elements) {
        this.pushScope();
        Scope scope = this.getCurrentScope();
        scope.elements = elements;
        scope.index = 0;
        scope.size = this.mElements.size();
    }

    public E[] finish() {
        Scope scope = this.getCurrentScope();
        this.popScope();
        E[] result = null;
        int size = this.mElements.size() - scope.size;
        if (scope.index != scope.elements.length) {
            result = this.extractElements(size);
        } else {
            for (int i = 0; i < size; ++i) {
                this.mElements.pollLast();
            }
        }
        scope.elements = null;
        return result;
    }

    public void add(E element) {
        Scope scope = this.getCurrentScope();
        scope.index = scope.index < scope.elements.length && scope.elements[scope.index] == element ? ++scope.index : Integer.MAX_VALUE;
        this.mElements.add(element);
    }

    public void clear() {
        if (this.getCurrentScope() != null) {
            throw new RuntimeException("Must call finish() for every start() call being made.");
        }
        this.mElements.clear();
    }

    private E[] extractElements(int size) {
        if (size == 0) {
            return this.mEmptyArray;
        }
        Object[] elements = (Object[])Array.newInstance(this.mEmptyArray.getClass().getComponentType(), size);
        for (int i = size - 1; i >= 0; --i) {
            elements[i] = this.mElements.pollLast();
        }
        return elements;
    }

    private void pushScope() {
        ++this.mScopeIndex;
        if (this.mScopeIndex == this.mScopesStack.size()) {
            this.mCurrentScope = new Scope();
            this.mScopesStack.add(this.mCurrentScope);
        } else {
            this.mCurrentScope = this.mScopesStack.get(this.mScopeIndex);
        }
    }

    private void popScope() {
        --this.mScopeIndex;
        this.mCurrentScope = this.mScopesStack.get(this.mScopeIndex);
    }

    private Scope getCurrentScope() {
        return this.mCurrentScope;
    }

    private static final class Scope {
        Object[] elements;
        int index;
        int size;

        private Scope() {
        }
    }
}

