/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RectF;
import com.facebook.react.flat.AbstractDrawCommand;
import javax.annotation.Nullable;

abstract class AbstractDrawBorder
extends AbstractDrawCommand {
    private static final Paint PAINT = new Paint(1);
    private static final RectF TMP_RECT = new RectF();
    private static final int BORDER_PATH_DIRTY = 1;
    private int mSetPropertiesFlag;
    private int mBorderColor = -16777216;
    private float mBorderWidth;
    private float mBorderRadius;
    @Nullable
    private Path mPathForBorderRadius;

    AbstractDrawBorder() {
    }

    public final void setBorderWidth(float borderWidth) {
        this.mBorderWidth = borderWidth;
        this.setFlag(1);
    }

    public final float getBorderWidth() {
        return this.mBorderWidth;
    }

    public void setBorderRadius(float borderRadius) {
        this.mBorderRadius = borderRadius;
        this.setFlag(1);
    }

    public final float getBorderRadius() {
        return this.mBorderRadius;
    }

    public final void setBorderColor(int borderColor) {
        this.mBorderColor = borderColor;
    }

    public final int getBorderColor() {
        return this.mBorderColor;
    }

    @Override
    protected void onBoundsChanged() {
        this.setFlag(1);
    }

    protected final void drawBorders(Canvas canvas) {
        if (this.mBorderWidth < 0.5f) {
            return;
        }
        if (this.mBorderColor == 0) {
            return;
        }
        PAINT.setColor(this.mBorderColor);
        PAINT.setStrokeWidth(this.mBorderWidth);
        PAINT.setPathEffect(this.getPathEffectForBorderStyle());
        canvas.drawPath(this.getPathForBorderRadius(), PAINT);
    }

    protected final void updatePath(Path path, float correction) {
        path.reset();
        TMP_RECT.set(this.getLeft() + correction, this.getTop() + correction, this.getRight() - correction, this.getBottom() - correction);
        path.addRoundRect(TMP_RECT, this.mBorderRadius, this.mBorderRadius, Path.Direction.CW);
    }

    @Nullable
    protected PathEffect getPathEffectForBorderStyle() {
        return null;
    }

    protected final boolean isFlagSet(int mask) {
        return (this.mSetPropertiesFlag & mask) == mask;
    }

    protected final void setFlag(int mask) {
        this.mSetPropertiesFlag |= mask;
    }

    protected final void resetFlag(int mask) {
        this.mSetPropertiesFlag &= ~mask;
    }

    protected final Path getPathForBorderRadius() {
        if (this.isFlagSet(1)) {
            if (this.mPathForBorderRadius == null) {
                this.mPathForBorderRadius = new Path();
            }
            this.updatePath(this.mPathForBorderRadius, this.mBorderWidth * 0.5f);
            this.resetFlag(1);
        }
        return this.mPathForBorderRadius;
    }

    static {
        PAINT.setStyle(Paint.Style.STROKE);
    }
}

