/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.view.MotionEvent;
import android.view.ViewGroup;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.uimanager.TouchTargetHelper;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.TouchEvent;
import com.facebook.react.uimanager.events.TouchEventCoalescingKeyHelper;
import com.facebook.react.uimanager.events.TouchEventType;

public class JSTouchDispatcher {
    private int mTargetTag = -1;
    private final float[] mTargetCoordinates = new float[2];
    private boolean mChildIsHandlingNativeGesture = false;
    private long mGestureStartTime = Long.MIN_VALUE;
    private final ViewGroup mRootViewGroup;
    private final TouchEventCoalescingKeyHelper mTouchEventCoalescingKeyHelper = new TouchEventCoalescingKeyHelper();

    public JSTouchDispatcher(ViewGroup viewGroup) {
        this.mRootViewGroup = viewGroup;
    }

    public void onChildStartedNativeGesture(MotionEvent androidEvent, EventDispatcher eventDispatcher) {
        if (this.mChildIsHandlingNativeGesture) {
            return;
        }
        this.dispatchCancelEvent(androidEvent, eventDispatcher);
        this.mChildIsHandlingNativeGesture = true;
        this.mTargetTag = -1;
    }

    public void handleTouchEvent(MotionEvent ev, EventDispatcher eventDispatcher) {
        int action = ev.getAction() & 0xFF;
        if (action == 0) {
            if (this.mTargetTag != -1) {
                FLog.e((String)"ReactNative", (String)"Got DOWN touch before receiving UP or CANCEL from last gesture");
            }
            this.mChildIsHandlingNativeGesture = false;
            this.mGestureStartTime = ev.getEventTime();
            this.mTargetTag = this.findTargetTagAndSetCoordinates(ev);
            eventDispatcher.dispatchEvent(TouchEvent.obtain(this.mTargetTag, TouchEventType.START, ev, this.mGestureStartTime, this.mTargetCoordinates[0], this.mTargetCoordinates[1], this.mTouchEventCoalescingKeyHelper));
        } else {
            if (this.mChildIsHandlingNativeGesture) {
                return;
            }
            if (this.mTargetTag == -1) {
                FLog.e((String)"ReactNative", (String)"Unexpected state: received touch event but didn't get starting ACTION_DOWN for this gesture before");
            } else if (action == 1) {
                this.findTargetTagAndSetCoordinates(ev);
                eventDispatcher.dispatchEvent(TouchEvent.obtain(this.mTargetTag, TouchEventType.END, ev, this.mGestureStartTime, this.mTargetCoordinates[0], this.mTargetCoordinates[1], this.mTouchEventCoalescingKeyHelper));
                this.mTargetTag = -1;
                this.mGestureStartTime = Long.MIN_VALUE;
            } else if (action == 2) {
                this.findTargetTagAndSetCoordinates(ev);
                eventDispatcher.dispatchEvent(TouchEvent.obtain(this.mTargetTag, TouchEventType.MOVE, ev, this.mGestureStartTime, this.mTargetCoordinates[0], this.mTargetCoordinates[1], this.mTouchEventCoalescingKeyHelper));
            } else if (action == 5) {
                eventDispatcher.dispatchEvent(TouchEvent.obtain(this.mTargetTag, TouchEventType.START, ev, this.mGestureStartTime, this.mTargetCoordinates[0], this.mTargetCoordinates[1], this.mTouchEventCoalescingKeyHelper));
            } else if (action == 6) {
                eventDispatcher.dispatchEvent(TouchEvent.obtain(this.mTargetTag, TouchEventType.END, ev, this.mGestureStartTime, this.mTargetCoordinates[0], this.mTargetCoordinates[1], this.mTouchEventCoalescingKeyHelper));
            } else if (action == 3) {
                if (this.mTouchEventCoalescingKeyHelper.hasCoalescingKey(ev.getDownTime())) {
                    this.dispatchCancelEvent(ev, eventDispatcher);
                } else {
                    FLog.e((String)"ReactNative", (String)"Received an ACTION_CANCEL touch event for which we have no corresponding ACTION_DOWN");
                }
                this.mTargetTag = -1;
                this.mGestureStartTime = Long.MIN_VALUE;
            } else {
                FLog.w((String)"ReactNative", (String)("Warning : touch event was ignored. Action=" + action + " Target=" + this.mTargetTag));
            }
        }
    }

    private int findTargetTagAndSetCoordinates(MotionEvent ev) {
        return TouchTargetHelper.findTargetTagAndCoordinatesForTouch(ev.getX(), ev.getY(), this.mRootViewGroup, this.mTargetCoordinates, null);
    }

    private void dispatchCancelEvent(MotionEvent androidEvent, EventDispatcher eventDispatcher) {
        if (this.mTargetTag == -1) {
            FLog.w((String)"ReactNative", (String)"Can't cancel already finished gesture. Is a child View trying to start a gesture from an UP/CANCEL event?");
            return;
        }
        Assertions.assertCondition((!this.mChildIsHandlingNativeGesture ? 1 : 0) != 0, (String)"Expected to not have already sent a cancel for this gesture");
        ((EventDispatcher)Assertions.assertNotNull((Object)eventDispatcher)).dispatchEvent(TouchEvent.obtain(this.mTargetTag, TouchEventType.CANCEL, androidEvent, this.mGestureStartTime, this.mTargetCoordinates[0], this.mTargetCoordinates[1], this.mTouchEventCoalescingKeyHelper));
    }
}

