/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.view.KeyEvent;
import android.view.View;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.ReactApplication;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactNativeHost;
import com.facebook.react.ReactRootView;
import com.facebook.react.bridge.Callback;
import com.facebook.react.devsupport.DoubleTapReloadRecognizer;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.modules.core.PermissionListener;
import javax.annotation.Nullable;

public class ReactActivityDelegate {
    @Nullable
    private final Activity mActivity;
    @Nullable
    private final FragmentActivity mFragmentActivity;
    @Nullable
    private final String mMainComponentName;
    @Nullable
    private ReactRootView mReactRootView;
    @Nullable
    private DoubleTapReloadRecognizer mDoubleTapReloadRecognizer;
    @Nullable
    private PermissionListener mPermissionListener;
    @Nullable
    private Callback mPermissionsCallback;

    public ReactActivityDelegate(Activity activity, @Nullable String mainComponentName) {
        this.mActivity = activity;
        this.mMainComponentName = mainComponentName;
        this.mFragmentActivity = null;
    }

    public ReactActivityDelegate(FragmentActivity fragmentActivity, @Nullable String mainComponentName) {
        this.mFragmentActivity = fragmentActivity;
        this.mMainComponentName = mainComponentName;
        this.mActivity = null;
    }

    @Nullable
    protected Bundle getLaunchOptions() {
        return null;
    }

    protected ReactRootView createRootView() {
        return new ReactRootView(this.getContext());
    }

    protected ReactNativeHost getReactNativeHost() {
        return ((ReactApplication)this.getPlainActivity().getApplication()).getReactNativeHost();
    }

    public ReactInstanceManager getReactInstanceManager() {
        return this.getReactNativeHost().getReactInstanceManager();
    }

    protected void onCreate(Bundle savedInstanceState) {
        if (this.mMainComponentName != null) {
            this.loadApp(this.mMainComponentName);
        }
        this.mDoubleTapReloadRecognizer = new DoubleTapReloadRecognizer();
    }

    protected void loadApp(String appKey) {
        if (this.mReactRootView != null) {
            throw new IllegalStateException("Cannot loadApp while app is already running.");
        }
        this.mReactRootView = this.createRootView();
        this.mReactRootView.startReactApplication(this.getReactNativeHost().getReactInstanceManager(), appKey, this.getLaunchOptions());
        this.getPlainActivity().setContentView((View)this.mReactRootView);
    }

    protected void onPause() {
        if (this.getReactNativeHost().hasInstance()) {
            this.getReactNativeHost().getReactInstanceManager().onHostPause(this.getPlainActivity());
        }
    }

    protected void onResume() {
        if (this.getReactNativeHost().hasInstance()) {
            this.getReactNativeHost().getReactInstanceManager().onHostResume(this.getPlainActivity(), (DefaultHardwareBackBtnHandler)this.getPlainActivity());
        }
        if (this.mPermissionsCallback != null) {
            this.mPermissionsCallback.invoke(new Object[0]);
            this.mPermissionsCallback = null;
        }
    }

    protected void onDestroy() {
        if (this.mReactRootView != null) {
            this.mReactRootView.unmountReactApplication();
            this.mReactRootView = null;
        }
        if (this.getReactNativeHost().hasInstance()) {
            this.getReactNativeHost().getReactInstanceManager().onHostDestroy(this.getPlainActivity());
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.getReactNativeHost().hasInstance()) {
            this.getReactNativeHost().getReactInstanceManager().onActivityResult(this.getPlainActivity(), requestCode, resultCode, data);
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.getReactNativeHost().hasInstance() && this.getReactNativeHost().getUseDeveloperSupport() && keyCode == 90) {
            event.startTracking();
            return true;
        }
        return false;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.getReactNativeHost().hasInstance() && this.getReactNativeHost().getUseDeveloperSupport()) {
            if (keyCode == 82) {
                this.getReactNativeHost().getReactInstanceManager().showDevOptionsDialog();
                return true;
            }
            boolean didDoubleTapR = ((DoubleTapReloadRecognizer)Assertions.assertNotNull((Object)this.mDoubleTapReloadRecognizer)).didDoubleTapR(keyCode, this.getPlainActivity().getCurrentFocus());
            if (didDoubleTapR) {
                this.getReactNativeHost().getReactInstanceManager().getDevSupportManager().handleReloadJS();
                return true;
            }
        }
        return false;
    }

    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        if (this.getReactNativeHost().hasInstance() && this.getReactNativeHost().getUseDeveloperSupport() && keyCode == 90) {
            this.getReactNativeHost().getReactInstanceManager().showDevOptionsDialog();
            return true;
        }
        return false;
    }

    public boolean onBackPressed() {
        if (this.getReactNativeHost().hasInstance()) {
            this.getReactNativeHost().getReactInstanceManager().onBackPressed();
            return true;
        }
        return false;
    }

    public boolean onNewIntent(Intent intent) {
        if (this.getReactNativeHost().hasInstance()) {
            this.getReactNativeHost().getReactInstanceManager().onNewIntent(intent);
            return true;
        }
        return false;
    }

    @TargetApi(value=23)
    public void requestPermissions(String[] permissions, int requestCode, PermissionListener listener) {
        this.mPermissionListener = listener;
        this.getPlainActivity().requestPermissions(permissions, requestCode);
    }

    public void onRequestPermissionsResult(final int requestCode, final String[] permissions, final int[] grantResults) {
        this.mPermissionsCallback = new Callback(){

            @Override
            public void invoke(Object ... args) {
                if (ReactActivityDelegate.this.mPermissionListener != null && ReactActivityDelegate.this.mPermissionListener.onRequestPermissionsResult(requestCode, permissions, grantResults)) {
                    ReactActivityDelegate.this.mPermissionListener = null;
                }
            }
        };
    }

    private Context getContext() {
        if (this.mActivity != null) {
            return this.mActivity;
        }
        return (Context)Assertions.assertNotNull((Object)this.mFragmentActivity);
    }

    private Activity getPlainActivity() {
        return (Activity)this.getContext();
    }
}

