/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.text.SpannableStringBuilder;
import com.facebook.react.flat.FlatShadowNode;
import com.facebook.react.flat.StateBuilder;
import com.facebook.react.uimanager.ReactShadowNodeImpl;

abstract class FlatTextShadowNode
extends FlatShadowNode {
    private int mTextBegin;
    private int mTextEnd;

    FlatTextShadowNode() {
    }

    protected void notifyChanged(boolean shouldRemeasure) {
        ReactShadowNodeImpl parent = this.getParent();
        if (parent instanceof FlatTextShadowNode) {
            ((FlatTextShadowNode)parent).notifyChanged(shouldRemeasure);
        }
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    final void collectText(SpannableStringBuilder builder) {
        this.mTextBegin = builder.length();
        this.performCollectText(builder);
        this.mTextEnd = builder.length();
    }

    boolean shouldAllowEmptySpans() {
        return false;
    }

    boolean isEditable() {
        return false;
    }

    final void applySpans(SpannableStringBuilder builder, boolean isEditable) {
        if (this.mTextBegin != this.mTextEnd || this.shouldAllowEmptySpans()) {
            this.performApplySpans(builder, this.mTextBegin, this.mTextEnd, isEditable);
        }
    }

    protected abstract void performCollectText(SpannableStringBuilder var1);

    protected abstract void performApplySpans(SpannableStringBuilder var1, int var2, int var3, boolean var4);

    protected abstract void performCollectAttachDetachListeners(StateBuilder var1);
}

