/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.Task;
import com.google.android.gms.gcm.zzf;

public class OneoffTask
extends Task {
    private final long zzbfV;
    private final long zzbfW;
    public static final Parcelable.Creator<OneoffTask> CREATOR = new zzf();

    private OneoffTask(Builder builder) {
        super(builder);
        this.zzbfV = builder.zzbfX;
        this.zzbfW = builder.zzbfY;
    }

    @Deprecated
    private OneoffTask(Parcel parcel) {
        super(parcel);
        this.zzbfV = parcel.readLong();
        this.zzbfW = parcel.readLong();
    }

    @Override
    public void toBundle(Bundle bundle) {
        super.toBundle(bundle);
        bundle.putLong("window_start", this.zzbfV);
        bundle.putLong("window_end", this.zzbfW);
    }

    public long getWindowStart() {
        return this.zzbfV;
    }

    public long getWindowEnd() {
        return this.zzbfW;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        super.writeToParcel(parcel, n);
        parcel.writeLong(this.zzbfV);
        parcel.writeLong(this.zzbfW);
    }

    public String toString() {
        String string = String.valueOf(super.toString());
        long l = this.getWindowStart();
        long l2 = this.getWindowEnd();
        return new StringBuilder(64 + String.valueOf(string).length()).append(string).append(" windowStart=").append(l).append(" windowEnd=").append(l2).toString();
    }

    /* synthetic */ OneoffTask(Parcel parcel, zzf zzf2) {
        this(parcel);
    }

    /* synthetic */ OneoffTask(Builder builder, zzf zzf2) {
        this(builder);
    }

    public static class Builder
    extends Task.Builder {
        private long zzbfX = -1L;
        private long zzbfY = -1L;

        public Builder() {
            this.isPersisted = false;
        }

        public Builder setExecutionWindow(long l, long l2) {
            this.zzbfX = l;
            this.zzbfY = l2;
            return this;
        }

        @Override
        public Builder setService(Class<? extends GcmTaskService> clazz) {
            this.gcmTaskService = clazz.getName();
            return this;
        }

        @Override
        public Builder setRequiredNetwork(int n) {
            this.requiredNetworkState = n;
            return this;
        }

        @Override
        public Builder setRequiresCharging(boolean bl) {
            this.requiresCharging = bl;
            return this;
        }

        @Override
        public Builder setTag(String string) {
            this.tag = string;
            return this;
        }

        @Override
        public Builder setPersisted(boolean bl) {
            this.isPersisted = bl;
            return this;
        }

        @Override
        public Builder setUpdateCurrent(boolean bl) {
            this.updateCurrent = bl;
            return this;
        }

        @Override
        public Builder setExtras(Bundle bundle) {
            this.extras = bundle;
            return this;
        }

        @Override
        protected void checkConditions() {
            super.checkConditions();
            if (this.zzbfX == -1L || this.zzbfY == -1L) {
                throw new IllegalArgumentException("Must specify an execution window using setExecutionWindow.");
            }
            if (this.zzbfX >= this.zzbfY) {
                throw new IllegalArgumentException("Window start must be shorter than window end.");
            }
        }

        @Override
        public OneoffTask build() {
            this.checkConditions();
            return new OneoffTask(this, null);
        }
    }
}

