/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import com.facebook.react.LazyReactPackage;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactPackageLogger;
import com.facebook.react.bridge.ModuleSpec;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.module.model.ReactModuleInfoProvider;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.core.ExceptionsManagerModule;
import com.facebook.react.modules.core.HeadlessJsTaskSupportModule;
import com.facebook.react.modules.core.Timing;
import com.facebook.react.modules.debug.SourceCodeModule;
import com.facebook.react.modules.deviceinfo.DeviceInfoModule;
import com.facebook.react.modules.systeminfo.AndroidInfoModule;
import com.facebook.react.uimanager.UIImplementationProvider;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.systrace.Systrace;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Provider;

class CoreModulesPackage
extends LazyReactPackage
implements ReactPackageLogger {
    private final ReactInstanceManager mReactInstanceManager;
    private final DefaultHardwareBackBtnHandler mHardwareBackBtnHandler;
    private final UIImplementationProvider mUIImplementationProvider;
    private final boolean mLazyViewManagersEnabled;
    private final int mMinTimeLeftInFrameForNonBatchedOperationMs;

    CoreModulesPackage(ReactInstanceManager reactInstanceManager, DefaultHardwareBackBtnHandler hardwareBackBtnHandler, UIImplementationProvider uiImplementationProvider, boolean lazyViewManagersEnabled, int minTimeLeftInFrameForNonBatchedOperationMs) {
        this.mReactInstanceManager = reactInstanceManager;
        this.mHardwareBackBtnHandler = hardwareBackBtnHandler;
        this.mUIImplementationProvider = uiImplementationProvider;
        this.mLazyViewManagersEnabled = lazyViewManagersEnabled;
        this.mMinTimeLeftInFrameForNonBatchedOperationMs = minTimeLeftInFrameForNonBatchedOperationMs;
    }

    @Override
    public List<ModuleSpec> getNativeModules(final ReactApplicationContext reactContext) {
        return Arrays.asList(ModuleSpec.nativeModuleSpec(AndroidInfoModule.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return new AndroidInfoModule();
            }
        }), ModuleSpec.nativeModuleSpec(DeviceEventManagerModule.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return new DeviceEventManagerModule(reactContext, CoreModulesPackage.this.mHardwareBackBtnHandler);
            }
        }), ModuleSpec.nativeModuleSpec(ExceptionsManagerModule.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return new ExceptionsManagerModule(CoreModulesPackage.this.mReactInstanceManager.getDevSupportManager());
            }
        }), ModuleSpec.nativeModuleSpec(HeadlessJsTaskSupportModule.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return new HeadlessJsTaskSupportModule(reactContext);
            }
        }), ModuleSpec.nativeModuleSpec(SourceCodeModule.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return new SourceCodeModule(reactContext);
            }
        }), ModuleSpec.nativeModuleSpec(Timing.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return new Timing(reactContext, CoreModulesPackage.this.mReactInstanceManager.getDevSupportManager());
            }
        }), ModuleSpec.nativeModuleSpec(UIManagerModule.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return CoreModulesPackage.this.createUIManager(reactContext);
            }
        }), ModuleSpec.nativeModuleSpec(DeviceInfoModule.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return new DeviceInfoModule(reactContext);
            }
        }));
    }

    @Override
    public ReactModuleInfoProvider getReactModuleInfoProvider() {
        return LazyReactPackage.getReactModuleInfoProviderViaReflection(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UIManagerModule createUIManager(ReactApplicationContext reactContext) {
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_UI_MANAGER_MODULE_START);
        Systrace.beginSection(0L, "createUIManagerModule");
        try {
            if (this.mLazyViewManagersEnabled) {
                UIManagerModule.ViewManagerResolver resolver = new UIManagerModule.ViewManagerResolver(){

                    @Override
                    @Nullable
                    public ViewManager getViewManager(String viewManagerName) {
                        return CoreModulesPackage.this.mReactInstanceManager.createViewManager(viewManagerName);
                    }

                    @Override
                    public List<String> getViewManagerNames() {
                        return CoreModulesPackage.this.mReactInstanceManager.getViewManagerNames();
                    }
                };
                UIManagerModule uIManagerModule = new UIManagerModule(reactContext, resolver, this.mUIImplementationProvider, this.mMinTimeLeftInFrameForNonBatchedOperationMs);
                return uIManagerModule;
            }
            UIManagerModule uIManagerModule = new UIManagerModule(reactContext, this.mReactInstanceManager.createAllViewManagers(reactContext), this.mUIImplementationProvider, this.mMinTimeLeftInFrameForNonBatchedOperationMs);
            return uIManagerModule;
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.CREATE_UI_MANAGER_MODULE_END);
        }
    }

    @Override
    public void startProcessPackage() {
        ReactMarker.logMarker(ReactMarkerConstants.PROCESS_CORE_REACT_PACKAGE_START);
    }

    @Override
    public void endProcessPackage() {
        ReactMarker.logMarker(ReactMarkerConstants.PROCESS_CORE_REACT_PACKAGE_END);
    }
}

