/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.bitmaps;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.util.DisplayMetrics;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import javax.annotation.Nullable;

public abstract class PlatformBitmapFactory {
    private static BitmapCreationObserver sBitmapCreationObserver;

    public CloseableReference<Bitmap> createBitmap(int width, int height, Bitmap.Config bitmapConfig) {
        return this.createBitmap(width, height, bitmapConfig, null);
    }

    public CloseableReference<Bitmap> createBitmap(int width, int height) {
        return this.createBitmap(width, height, Bitmap.Config.ARGB_8888);
    }

    public CloseableReference<Bitmap> createBitmap(int width, int height, Bitmap.Config bitmapConfig, @Nullable Object callerContext) {
        CloseableReference<Bitmap> reference = this.createBitmapInternal(width, height, bitmapConfig);
        this.addBitmapReference((Bitmap)reference.get(), callerContext);
        return reference;
    }

    public CloseableReference<Bitmap> createBitmap(int width, int height, @Nullable Object callerContext) {
        return this.createBitmap(width, height, Bitmap.Config.ARGB_8888, callerContext);
    }

    public CloseableReference<Bitmap> createBitmap(Bitmap source) {
        return this.createBitmap(source, null);
    }

    public CloseableReference<Bitmap> createBitmap(Bitmap source, @Nullable Object callerContext) {
        return this.createBitmap(source, 0, 0, source.getWidth(), source.getHeight(), callerContext);
    }

    public CloseableReference<Bitmap> createBitmap(Bitmap source, int x, int y, int width, int height) {
        return this.createBitmap(source, x, y, width, height, null);
    }

    public CloseableReference<Bitmap> createBitmap(Bitmap source, int x, int y, int width, int height, @Nullable Object callerContext) {
        return this.createBitmap(source, x, y, width, height, null, false, callerContext);
    }

    public CloseableReference<Bitmap> createBitmap(Bitmap source, int x, int y, int width, int height, @Nullable Matrix matrix, boolean filter) {
        return this.createBitmap(source, x, y, width, height, matrix, filter, null);
    }

    public CloseableReference<Bitmap> createScaledBitmap(Bitmap source, int destinationWidth, int destinationHeight, boolean filter) {
        return this.createScaledBitmap(source, destinationWidth, destinationHeight, filter, null);
    }

    public CloseableReference<Bitmap> createScaledBitmap(Bitmap source, int destinationWidth, int destinationHeight, boolean filter, @Nullable Object callerContext) {
        PlatformBitmapFactory.checkWidthHeight(destinationWidth, destinationHeight);
        Matrix matrix = new Matrix();
        int width = source.getWidth();
        int height = source.getHeight();
        float sx = (float)destinationWidth / (float)width;
        float sy = (float)destinationHeight / (float)height;
        matrix.setScale(sx, sy);
        return this.createBitmap(source, 0, 0, width, height, matrix, filter, callerContext);
    }

    public CloseableReference<Bitmap> createBitmap(Bitmap source, int x, int y, int width, int height, @Nullable Matrix matrix, boolean filter, @Nullable Object callerContext) {
        Paint paint;
        CloseableReference<Bitmap> bitmapRef;
        Preconditions.checkNotNull((Object)source, (Object)"Source bitmap cannot be null");
        PlatformBitmapFactory.checkXYSign(x, y);
        PlatformBitmapFactory.checkWidthHeight(width, height);
        PlatformBitmapFactory.checkFinalImageBounds(source, x, y, width, height);
        int newWidth = width;
        int newHeight = height;
        Canvas canvas = new Canvas();
        Rect srcRectangle = new Rect(x, y, x + width, y + height);
        RectF dstRectangle = new RectF(0.0f, 0.0f, (float)width, (float)height);
        Bitmap.Config newConfig = PlatformBitmapFactory.getSuitableBitmapConfig(source);
        if (matrix == null || matrix.isIdentity()) {
            bitmapRef = this.createBitmap(newWidth, newHeight, newConfig, source.hasAlpha(), callerContext);
            paint = null;
        } else {
            boolean transformed = !matrix.rectStaysRect();
            RectF deviceRectangle = new RectF();
            matrix.mapRect(deviceRectangle, dstRectangle);
            newWidth = Math.round(deviceRectangle.width());
            newHeight = Math.round(deviceRectangle.height());
            bitmapRef = this.createBitmap(newWidth, newHeight, transformed ? Bitmap.Config.ARGB_8888 : newConfig, transformed || source.hasAlpha(), callerContext);
            canvas.translate(-deviceRectangle.left, -deviceRectangle.top);
            canvas.concat(matrix);
            paint = new Paint();
            paint.setFilterBitmap(filter);
            if (transformed) {
                paint.setAntiAlias(true);
            }
        }
        Bitmap bitmap = (Bitmap)bitmapRef.get();
        bitmap.setDensity(source.getDensity());
        if (Build.VERSION.SDK_INT >= 12) {
            bitmap.setHasAlpha(source.hasAlpha());
        }
        if (Build.VERSION.SDK_INT >= 19) {
            bitmap.setPremultiplied(source.isPremultiplied());
        }
        canvas.setBitmap(bitmap);
        canvas.drawBitmap(source, srcRectangle, dstRectangle, paint);
        canvas.setBitmap(null);
        return bitmapRef;
    }

    public CloseableReference<Bitmap> createBitmap(DisplayMetrics display, int width, int height, Bitmap.Config config) {
        return this.createBitmap(display, width, height, config, null);
    }

    public CloseableReference<Bitmap> createBitmap(DisplayMetrics display, int width, int height, Bitmap.Config config, @Nullable Object callerContext) {
        return this.createBitmap(display, width, height, config, true, callerContext);
    }

    private CloseableReference<Bitmap> createBitmap(int width, int height, Bitmap.Config config, boolean hasAlpha) {
        return this.createBitmap(width, height, config, hasAlpha, null);
    }

    private CloseableReference<Bitmap> createBitmap(int width, int height, Bitmap.Config config, boolean hasAlpha, @Nullable Object callerContext) {
        return this.createBitmap(null, width, height, config, hasAlpha, callerContext);
    }

    private CloseableReference<Bitmap> createBitmap(DisplayMetrics display, int width, int height, Bitmap.Config config, boolean hasAlpha) {
        return this.createBitmap(display, width, height, config, hasAlpha, null);
    }

    private CloseableReference<Bitmap> createBitmap(DisplayMetrics display, int width, int height, Bitmap.Config config, boolean hasAlpha, @Nullable Object callerContext) {
        PlatformBitmapFactory.checkWidthHeight(width, height);
        CloseableReference<Bitmap> bitmapRef = this.createBitmapInternal(width, height, config);
        Bitmap bitmap = (Bitmap)bitmapRef.get();
        if (display != null) {
            bitmap.setDensity(display.densityDpi);
        }
        if (Build.VERSION.SDK_INT >= 12) {
            bitmap.setHasAlpha(hasAlpha);
        }
        if (config == Bitmap.Config.ARGB_8888 && !hasAlpha) {
            bitmap.eraseColor(-16777216);
        }
        this.addBitmapReference((Bitmap)bitmapRef.get(), callerContext);
        return bitmapRef;
    }

    public CloseableReference<Bitmap> createBitmap(int[] colors, int width, int height, Bitmap.Config config) {
        return this.createBitmap(colors, width, height, config, null);
    }

    public CloseableReference<Bitmap> createBitmap(int[] colors, int width, int height, Bitmap.Config config, @Nullable Object callerContext) {
        CloseableReference<Bitmap> bitmapRef = this.createBitmapInternal(width, height, config);
        Bitmap bitmap = (Bitmap)bitmapRef.get();
        bitmap.setPixels(colors, 0, width, 0, 0, width, height);
        this.addBitmapReference((Bitmap)bitmapRef.get(), callerContext);
        return bitmapRef;
    }

    public CloseableReference<Bitmap> createBitmap(DisplayMetrics display, int[] colors, int width, int height, Bitmap.Config config) {
        return this.createBitmap(display, colors, width, height, config, null);
    }

    public CloseableReference<Bitmap> createBitmap(DisplayMetrics display, int[] colors, int width, int height, Bitmap.Config config, @Nullable Object callerContext) {
        return this.createBitmap(display, colors, 0, width, width, height, config, callerContext);
    }

    public CloseableReference<Bitmap> createBitmap(DisplayMetrics display, int[] colors, int offset, int stride, int width, int height, Bitmap.Config config) {
        return this.createBitmap(display, colors, offset, stride, width, height, config, null);
    }

    public CloseableReference<Bitmap> createBitmap(DisplayMetrics display, int[] colors, int offset, int stride, int width, int height, Bitmap.Config config, @Nullable Object callerContext) {
        CloseableReference<Bitmap> bitmapRef = this.createBitmap(display, width, height, config, callerContext);
        Bitmap bitmap = (Bitmap)bitmapRef.get();
        bitmap.setPixels(colors, offset, stride, 0, 0, width, height);
        return bitmapRef;
    }

    private static Bitmap.Config getSuitableBitmapConfig(Bitmap source) {
        Bitmap.Config finalConfig = Bitmap.Config.ARGB_8888;
        Bitmap.Config sourceConfig = source.getConfig();
        if (sourceConfig != null) {
            switch (sourceConfig) {
                case RGB_565: {
                    finalConfig = Bitmap.Config.RGB_565;
                    break;
                }
                case ALPHA_8: {
                    finalConfig = Bitmap.Config.ALPHA_8;
                    break;
                }
                default: {
                    finalConfig = Bitmap.Config.ARGB_8888;
                }
            }
        }
        return finalConfig;
    }

    private static void checkWidthHeight(int width, int height) {
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0, (Object)"width must be > 0");
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0, (Object)"height must be > 0");
    }

    private static void checkXYSign(int x, int y) {
        Preconditions.checkArgument((x >= 0 ? 1 : 0) != 0, (Object)"x must be >= 0");
        Preconditions.checkArgument((y >= 0 ? 1 : 0) != 0, (Object)"y must be >= 0");
    }

    private static void checkFinalImageBounds(Bitmap source, int x, int y, int width, int height) {
        Preconditions.checkArgument((x + width <= source.getWidth() ? 1 : 0) != 0, (Object)"x + width must be <= bitmap.width()");
        Preconditions.checkArgument((y + height <= source.getHeight() ? 1 : 0) != 0, (Object)"y + height must be <= bitmap.height()");
    }

    public abstract CloseableReference<Bitmap> createBitmapInternal(int var1, int var2, Bitmap.Config var3);

    public void setCreationListener(BitmapCreationObserver bitmapCreationObserver) {
        if (sBitmapCreationObserver == null) {
            sBitmapCreationObserver = bitmapCreationObserver;
        }
    }

    public void addBitmapReference(Bitmap bitmap, @Nullable Object callerContext) {
        if (sBitmapCreationObserver != null) {
            sBitmapCreationObserver.onBitmapCreated(bitmap, callerContext);
        }
    }

    public static interface BitmapCreationObserver {
        public void onBitmapCreated(Bitmap var1, @Nullable Object var2);
    }
}

