/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.util.ArrayMap;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzbau;
import com.google.android.gms.internal.zzbay;
import com.google.android.gms.internal.zzbbi;
import com.google.android.gms.internal.zzbcp;
import com.google.android.gms.internal.zzbdr;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbei;
import com.google.android.gms.internal.zzbes;
import com.google.android.gms.internal.zzctg;
import com.google.android.gms.internal.zzctk;
import com.google.android.gms.internal.zzctl;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public abstract class GoogleApiClient {
    private static final Set<GoogleApiClient> zzaAS = Collections.newSetFromMap(new WeakHashMap());
    public static final int SIGN_IN_MODE_REQUIRED = 1;
    public static final int SIGN_IN_MODE_OPTIONAL = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpAll(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        Set<GoogleApiClient> set = zzaAS;
        synchronized (set) {
            int n = 0;
            String string3 = String.valueOf(string2).concat("  ");
            for (GoogleApiClient googleApiClient : zzaAS) {
                printWriter.append(string2).append("GoogleApiClient#").println(n++);
                googleApiClient.dump(string3, fileDescriptor, printWriter, stringArray);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<GoogleApiClient> zzpk() {
        Set<GoogleApiClient> set = zzaAS;
        synchronized (set) {
            return zzaAS;
        }
    }

    public <A extends Api.zzb, R extends Result, T extends zzbay<R, A>> T zzd(@NonNull T t) {
        throw new UnsupportedOperationException();
    }

    public <A extends Api.zzb, T extends zzbay<? extends Result, A>> T zze(@NonNull T t) {
        throw new UnsupportedOperationException();
    }

    public <L> zzbdw<L> zzp(@NonNull L l) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        throw new UnsupportedOperationException();
    }

    public boolean zza(@NonNull Api<?> api) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean hasConnectedApi(@NonNull Api<?> var1);

    @NonNull
    public abstract ConnectionResult getConnectionResult(@NonNull Api<?> var1);

    public Context getContext() {
        throw new UnsupportedOperationException();
    }

    public Looper getLooper() {
        throw new UnsupportedOperationException();
    }

    public boolean zza(zzbei zzbei2) {
        throw new UnsupportedOperationException();
    }

    public void zzpl() {
        throw new UnsupportedOperationException();
    }

    public abstract void connect();

    public void connect(int n) {
        throw new UnsupportedOperationException();
    }

    public abstract ConnectionResult blockingConnect();

    public abstract ConnectionResult blockingConnect(long var1, @NonNull TimeUnit var3);

    public abstract void disconnect();

    public abstract void reconnect();

    public abstract PendingResult<Status> clearDefaultAccountAndReconnect();

    public abstract void stopAutoManage(@NonNull FragmentActivity var1);

    public abstract boolean isConnected();

    public abstract boolean isConnecting();

    public abstract void registerConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract boolean isConnectionCallbacksRegistered(@NonNull ConnectionCallbacks var1);

    public abstract void unregisterConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract void registerConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public abstract boolean isConnectionFailedListenerRegistered(@NonNull OnConnectionFailedListener var1);

    public abstract void unregisterConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public abstract void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

    public void zza(zzbes zzbes2) {
        throw new UnsupportedOperationException();
    }

    public void zzb(zzbes zzbes2) {
        throw new UnsupportedOperationException();
    }

    public static final class Builder {
        private Account zzajb;
        private final Set<Scope> zzaAT = new HashSet<Scope>();
        private final Set<Scope> zzaAU = new HashSet<Scope>();
        private int zzaAV;
        private View zzaAW;
        private String zzake;
        private String zzaAX;
        private final Map<Api<?>, zzr> zzaAY = new ArrayMap();
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> zzaAZ = new ArrayMap();
        private zzbdr zzaBa;
        private int zzaBb = -1;
        private OnConnectionFailedListener zzaBc;
        private Looper zzrM;
        private GoogleApiAvailability zzaBd = GoogleApiAvailability.getInstance();
        private Api.zza<? extends zzctk, zzctl> zzaBe = zzctg.zzajS;
        private final ArrayList<ConnectionCallbacks> zzaBf = new ArrayList();
        private final ArrayList<OnConnectionFailedListener> zzaBg = new ArrayList();
        private boolean zzaBh = false;

        public Builder(@NonNull Context context) {
            this.mContext = context;
            this.zzrM = context.getMainLooper();
            this.zzake = context.getPackageName();
            this.zzaAX = context.getClass().getName();
        }

        public Builder(@NonNull Context context, @NonNull ConnectionCallbacks connectionCallbacks, @NonNull OnConnectionFailedListener onConnectionFailedListener) {
            this(context);
            zzbo.zzb((Object)connectionCallbacks, (Object)"Must provide a connected listener");
            this.zzaBf.add(connectionCallbacks);
            zzbo.zzb((Object)onConnectionFailedListener, (Object)"Must provide a connection failed listener");
            this.zzaBg.add(onConnectionFailedListener);
        }

        public final Builder setHandler(@NonNull Handler handler) {
            zzbo.zzb((Object)handler, (Object)"Handler must not be null");
            this.zzrM = handler.getLooper();
            return this;
        }

        public final Builder addConnectionCallbacks(@NonNull ConnectionCallbacks connectionCallbacks) {
            zzbo.zzb((Object)connectionCallbacks, (Object)"Listener must not be null");
            this.zzaBf.add(connectionCallbacks);
            return this;
        }

        public final Builder addOnConnectionFailedListener(@NonNull OnConnectionFailedListener onConnectionFailedListener) {
            zzbo.zzb((Object)onConnectionFailedListener, (Object)"Listener must not be null");
            this.zzaBg.add(onConnectionFailedListener);
            return this;
        }

        public final Builder setViewForPopups(@NonNull View view) {
            zzbo.zzb((Object)view, (Object)"View must not be null");
            this.zzaAW = view;
            return this;
        }

        public final Builder addScope(@NonNull Scope scope) {
            zzbo.zzb((Object)scope, (Object)"Scope must not be null");
            this.zzaAT.add(scope);
            return this;
        }

        public final Builder addApi(@NonNull Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            zzbo.zzb(api, (Object)"Api must not be null");
            this.zzaAZ.put(api, null);
            List<Scope> list = api.zzpb().zzn(null);
            this.zzaAU.addAll(list);
            this.zzaAT.addAll(list);
            return this;
        }

        public final Builder addApiIfAvailable(@NonNull Api<? extends Api.ApiOptions.NotRequiredOptions> api, Scope ... scopeArray) {
            zzbo.zzb(api, (Object)"Api must not be null");
            this.zzaAZ.put(api, null);
            this.zza(api, null, scopeArray);
            return this;
        }

        public final <O extends Api.ApiOptions.HasOptions> Builder addApi(@NonNull Api<O> api, @NonNull O o) {
            zzbo.zzb(api, (Object)"Api must not be null");
            zzbo.zzb(o, (Object)"Null options are not permitted for this Api");
            this.zzaAZ.put(api, o);
            List<Scope> list = api.zzpb().zzn(o);
            this.zzaAU.addAll(list);
            this.zzaAT.addAll(list);
            return this;
        }

        public final <O extends Api.ApiOptions.HasOptions> Builder addApiIfAvailable(@NonNull Api<O> api, @NonNull O o, Scope ... scopeArray) {
            zzbo.zzb(api, (Object)"Api must not be null");
            zzbo.zzb(o, (Object)"Null options are not permitted for this Api");
            this.zzaAZ.put(api, o);
            this.zza(api, o, scopeArray);
            return this;
        }

        public final Builder setAccountName(String string2) {
            this.zzajb = string2 == null ? null : new Account(string2, "com.google");
            return this;
        }

        public final Builder zze(Account account) {
            this.zzajb = account;
            return this;
        }

        public final Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public final Builder setGravityForPopups(int n) {
            this.zzaAV = n;
            return this;
        }

        public final Builder enableAutoManage(@NonNull FragmentActivity fragmentActivity, int n, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            OnConnectionFailedListener onConnectionFailedListener2 = onConnectionFailedListener;
            zzbdr zzbdr2 = new zzbdr((Activity)fragmentActivity);
            Builder builder = this;
            zzbo.zzb((n >= 0 ? 1 : 0) != 0, (Object)"clientId must be non-negative");
            builder.zzaBb = n;
            builder.zzaBc = onConnectionFailedListener2;
            builder.zzaBa = zzbdr2;
            return builder;
        }

        public final Builder enableAutoManage(@NonNull FragmentActivity fragmentActivity, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            return this.enableAutoManage(fragmentActivity, 0, onConnectionFailedListener);
        }

        public final zzq zzpn() {
            zzctl zzctl2 = zzctl.zzbCM;
            if (this.zzaAZ.containsKey(zzctg.API)) {
                zzctl2 = (zzctl)this.zzaAZ.get(zzctg.API);
            }
            return new zzq(this.zzajb, this.zzaAT, this.zzaAY, this.zzaAV, this.zzaAW, this.zzake, this.zzaAX, zzctl2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final GoogleApiClient build() {
            zzbo.zzb((!this.zzaAZ.isEmpty() ? 1 : 0) != 0, (Object)"must call addApi() to add at least one API");
            Builder builder = this;
            Object object = builder.zzpn();
            Api<?> api = null;
            boolean bl = false;
            Map<Api<?>, zzr> map = ((zzq)object).zzrp();
            ArrayMap arrayMap = new ArrayMap();
            ArrayMap arrayMap2 = new ArrayMap();
            ArrayList<zzbbi> arrayList = new ArrayList<zzbbi>();
            for (Api<?> api2 : builder.zzaAZ.keySet()) {
                Api.ApiOptions apiOptions = builder.zzaAZ.get(api2);
                boolean bl2 = map.get(api2) != null;
                arrayMap.put(api2, bl2);
                zzbbi zzbbi2 = new zzbbi(api2, bl2);
                arrayList.add(zzbbi2);
                Object object2 = api2.zzpc();
                Api.zza<?, ?> zza2 = object2;
                zzbbi zzbbi3 = zzbbi2;
                zzbbi zzbbi4 = zzbbi2;
                zzq zzq2 = object;
                Looper looper = builder.zzrM;
                Context context = builder.mContext;
                Api.ApiOptions apiOptions2 = apiOptions;
                Object obj = ((Api.zza)object2).zza(context, looper, zzq2, apiOptions2, zzbbi4, zzbbi3);
                arrayMap2.put(api2.zzpd(), obj);
                if (zza2.getPriority() == 1) {
                    boolean bl3 = bl = apiOptions != null;
                }
                if (!obj.zzmG()) continue;
                if (api != null) {
                    object2 = String.valueOf(api2.getName());
                    String string2 = String.valueOf(api.getName());
                    throw new IllegalStateException(new StringBuilder(21 + String.valueOf(object2).length() + String.valueOf(string2).length()).append((String)object2).append(" cannot be used with ").append(string2).toString());
                }
                api = api2;
            }
            if (api != null) {
                if (bl) {
                    String string3 = String.valueOf(api.getName());
                    throw new IllegalStateException(new StringBuilder(82 + String.valueOf(string3).length()).append("With using ").append(string3).append(", GamesOptions can only be specified within GoogleSignInOptions.Builder").toString());
                }
                zzbo.zza((builder.zzajb == null ? 1 : 0) != 0, (String)"Must not set an account in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead", (Object[])new Object[]{api.getName()});
                zzbo.zza((boolean)builder.zzaAT.equals(builder.zzaAU), (String)"Must not set scopes in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead.", (Object[])new Object[]{api.getName()});
            }
            int n = zzbcp.zza(arrayMap2.values(), true);
            zzbcp zzbcp2 = new zzbcp(builder.mContext, new ReentrantLock(), builder.zzrM, (zzq)object, builder.zzaBd, builder.zzaBe, (Map<Api<?>, Boolean>)arrayMap, (List<ConnectionCallbacks>)builder.zzaBf, (List<OnConnectionFailedListener>)builder.zzaBg, (Map<Api.zzc<?>, Api.zze>)arrayMap2, builder.zzaBb, n, arrayList, false);
            Set set = zzaAS;
            synchronized (set) {
                zzaAS.add(zzbcp2);
            }
            if (this.zzaBb >= 0) {
                object = zzbcp2;
                builder = this;
                zzbau.zza(builder.zzaBa).zza(builder.zzaBb, (GoogleApiClient)object, builder.zzaBc);
            }
            return zzbcp2;
        }

        private final <O extends Api.ApiOptions> void zza(Api<O> api, O o, Scope ... scopeArray) {
            HashSet<Scope> hashSet = new HashSet<Scope>(api.zzpb().zzn(o));
            Scope[] scopeArray2 = scopeArray;
            int n = scopeArray.length;
            for (int i = 0; i < n; ++i) {
                Scope scope = scopeArray2[i];
                hashSet.add(scope);
            }
            this.zzaAY.put(api, new zzr(hashSet));
        }
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(@Nullable Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

