/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.util.Log;
import com.facebook.common.internal.DoNotStrip;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.imagepipeline.nativecode.ImagePipelineNativeLoader;
import java.io.Closeable;

@DoNotStrip
public class NativeMemoryChunk
implements Closeable {
    private static final String TAG = "NativeMemoryChunk";
    private final long mNativePtr;
    private final int mSize;
    private boolean mClosed;

    public NativeMemoryChunk(int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0);
        this.mSize = size;
        this.mNativePtr = NativeMemoryChunk.nativeAllocate(this.mSize);
        this.mClosed = false;
    }

    @VisibleForTesting
    public NativeMemoryChunk() {
        this.mSize = 0;
        this.mNativePtr = 0L;
        this.mClosed = true;
    }

    @Override
    public synchronized void close() {
        if (!this.mClosed) {
            this.mClosed = true;
            NativeMemoryChunk.nativeFree(this.mNativePtr);
        }
    }

    public synchronized boolean isClosed() {
        return this.mClosed;
    }

    public int getSize() {
        return this.mSize;
    }

    public synchronized int write(int nativeMemoryOffset, byte[] byteArray, int byteArrayOffset, int count) {
        Preconditions.checkNotNull((Object)byteArray);
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        int actualCount = this.adjustByteCount(nativeMemoryOffset, count);
        this.checkBounds(nativeMemoryOffset, byteArray.length, byteArrayOffset, actualCount);
        NativeMemoryChunk.nativeCopyFromByteArray(this.mNativePtr + (long)nativeMemoryOffset, byteArray, byteArrayOffset, actualCount);
        return actualCount;
    }

    public synchronized int read(int nativeMemoryOffset, byte[] byteArray, int byteArrayOffset, int count) {
        Preconditions.checkNotNull((Object)byteArray);
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        int actualCount = this.adjustByteCount(nativeMemoryOffset, count);
        this.checkBounds(nativeMemoryOffset, byteArray.length, byteArrayOffset, actualCount);
        NativeMemoryChunk.nativeCopyToByteArray(this.mNativePtr + (long)nativeMemoryOffset, byteArray, byteArrayOffset, actualCount);
        return actualCount;
    }

    public synchronized byte read(int offset) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((offset < this.mSize ? 1 : 0) != 0);
        return NativeMemoryChunk.nativeReadByte(this.mNativePtr + (long)offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(int offset, NativeMemoryChunk other, int otherOffset, int count) {
        Preconditions.checkNotNull((Object)other);
        if (other.mNativePtr == this.mNativePtr) {
            Log.w((String)TAG, (String)("Copying from NativeMemoryChunk " + Integer.toHexString(System.identityHashCode(this)) + " to NativeMemoryChunk " + Integer.toHexString(System.identityHashCode(other)) + " which share the same address " + Long.toHexString(this.mNativePtr)));
            Preconditions.checkArgument((boolean)false);
        }
        if (other.mNativePtr < this.mNativePtr) {
            NativeMemoryChunk nativeMemoryChunk = other;
            synchronized (nativeMemoryChunk) {
                NativeMemoryChunk nativeMemoryChunk2 = this;
                synchronized (nativeMemoryChunk2) {
                    this.doCopy(offset, other, otherOffset, count);
                }
            }
            return;
        }
        NativeMemoryChunk nativeMemoryChunk = this;
        synchronized (nativeMemoryChunk) {
            NativeMemoryChunk nativeMemoryChunk3 = other;
            synchronized (nativeMemoryChunk3) {
                this.doCopy(offset, other, otherOffset, count);
            }
        }
    }

    public long getNativePtr() {
        return this.mNativePtr;
    }

    private void doCopy(int offset, NativeMemoryChunk other, int otherOffset, int count) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Preconditions.checkState((!other.isClosed() ? 1 : 0) != 0);
        this.checkBounds(offset, other.mSize, otherOffset, count);
        NativeMemoryChunk.nativeMemcpy(other.mNativePtr + (long)otherOffset, this.mNativePtr + (long)offset, count);
    }

    protected void finalize() throws Throwable {
        if (this.isClosed()) {
            return;
        }
        Log.w((String)TAG, (String)("finalize: Chunk " + Integer.toHexString(System.identityHashCode(this)) + " still active. Underlying address = " + Long.toHexString(this.mNativePtr)));
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private int adjustByteCount(int offset, int count) {
        int available = Math.max(0, this.mSize - offset);
        return Math.min(available, count);
    }

    private void checkBounds(int myOffset, int otherLength, int otherOffset, int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((myOffset >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((otherOffset >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((myOffset + count <= this.mSize ? 1 : 0) != 0);
        Preconditions.checkArgument((otherOffset + count <= otherLength ? 1 : 0) != 0);
    }

    @DoNotStrip
    private static native long nativeAllocate(int var0);

    @DoNotStrip
    private static native void nativeFree(long var0);

    @DoNotStrip
    private static native void nativeCopyToByteArray(long var0, byte[] var2, int var3, int var4);

    @DoNotStrip
    private static native void nativeCopyFromByteArray(long var0, byte[] var2, int var3, int var4);

    @DoNotStrip
    private static native void nativeMemcpy(long var0, long var2, int var4);

    @DoNotStrip
    private static native byte nativeReadByte(long var0);

    static {
        ImagePipelineNativeLoader.load();
    }
}

