/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import com.facebook.imagepipeline.memory.BitmapCounter;

public class BitmapCounterProvider {
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    public static final int MAX_BITMAP_TOTAL_SIZE = BitmapCounterProvider.getMaxSizeHardCap();
    public static final int MAX_BITMAP_COUNT = 384;
    private static BitmapCounter sBitmapCounter;

    private static int getMaxSizeHardCap() {
        int maxMemory = (int)Math.min(Runtime.getRuntime().maxMemory(), Integer.MAX_VALUE);
        if ((long)maxMemory > 0x1000000L) {
            return maxMemory / 4 * 3;
        }
        return maxMemory / 2;
    }

    public static BitmapCounter get() {
        if (sBitmapCounter == null) {
            sBitmapCounter = new BitmapCounter(384, MAX_BITMAP_TOTAL_SIZE);
        }
        return sBitmapCounter;
    }
}

