/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.decoder;

import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.decoder.ImageDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImageDecoderConfig {
    private final Map<ImageFormat, ImageDecoder> mCustomImageDecoders;
    private final List<ImageFormat.FormatChecker> mCustomImageFormats;

    private ImageDecoderConfig(Builder builder) {
        this.mCustomImageDecoders = builder.mCustomImageDecoders;
        this.mCustomImageFormats = builder.mCustomImageFormats;
    }

    public Map<ImageFormat, ImageDecoder> getCustomImageDecoders() {
        return this.mCustomImageDecoders;
    }

    public List<ImageFormat.FormatChecker> getCustomImageFormats() {
        return this.mCustomImageFormats;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Map<ImageFormat, ImageDecoder> mCustomImageDecoders;
        private List<ImageFormat.FormatChecker> mCustomImageFormats;

        public Builder addDecodingCapability(ImageFormat imageFormat, ImageFormat.FormatChecker imageFormatChecker, ImageDecoder decoder) {
            if (this.mCustomImageFormats == null) {
                this.mCustomImageFormats = new ArrayList<ImageFormat.FormatChecker>();
            }
            this.mCustomImageFormats.add(imageFormatChecker);
            this.overrideDecoder(imageFormat, decoder);
            return this;
        }

        public Builder overrideDecoder(ImageFormat imageFormat, ImageDecoder decoder) {
            if (this.mCustomImageDecoders == null) {
                this.mCustomImageDecoders = new HashMap<ImageFormat, ImageDecoder>();
            }
            this.mCustomImageDecoders.put(imageFormat, decoder);
            return this;
        }

        public ImageDecoderConfig build() {
            return new ImageDecoderConfig(this);
        }
    }
}

