/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.RestrictTo;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.MediaMetadataCompatApi21;
import android.support.v4.media.RatingCompat;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Set;

public final class MediaMetadataCompat
implements Parcelable {
    private static final String TAG = "MediaMetadata";
    public static final String METADATA_KEY_TITLE = "android.media.metadata.TITLE";
    public static final String METADATA_KEY_ARTIST = "android.media.metadata.ARTIST";
    public static final String METADATA_KEY_DURATION = "android.media.metadata.DURATION";
    public static final String METADATA_KEY_ALBUM = "android.media.metadata.ALBUM";
    public static final String METADATA_KEY_AUTHOR = "android.media.metadata.AUTHOR";
    public static final String METADATA_KEY_WRITER = "android.media.metadata.WRITER";
    public static final String METADATA_KEY_COMPOSER = "android.media.metadata.COMPOSER";
    public static final String METADATA_KEY_COMPILATION = "android.media.metadata.COMPILATION";
    public static final String METADATA_KEY_DATE = "android.media.metadata.DATE";
    public static final String METADATA_KEY_YEAR = "android.media.metadata.YEAR";
    public static final String METADATA_KEY_GENRE = "android.media.metadata.GENRE";
    public static final String METADATA_KEY_TRACK_NUMBER = "android.media.metadata.TRACK_NUMBER";
    public static final String METADATA_KEY_NUM_TRACKS = "android.media.metadata.NUM_TRACKS";
    public static final String METADATA_KEY_DISC_NUMBER = "android.media.metadata.DISC_NUMBER";
    public static final String METADATA_KEY_ALBUM_ARTIST = "android.media.metadata.ALBUM_ARTIST";
    public static final String METADATA_KEY_ART = "android.media.metadata.ART";
    public static final String METADATA_KEY_ART_URI = "android.media.metadata.ART_URI";
    public static final String METADATA_KEY_ALBUM_ART = "android.media.metadata.ALBUM_ART";
    public static final String METADATA_KEY_ALBUM_ART_URI = "android.media.metadata.ALBUM_ART_URI";
    public static final String METADATA_KEY_USER_RATING = "android.media.metadata.USER_RATING";
    public static final String METADATA_KEY_RATING = "android.media.metadata.RATING";
    public static final String METADATA_KEY_DISPLAY_TITLE = "android.media.metadata.DISPLAY_TITLE";
    public static final String METADATA_KEY_DISPLAY_SUBTITLE = "android.media.metadata.DISPLAY_SUBTITLE";
    public static final String METADATA_KEY_DISPLAY_DESCRIPTION = "android.media.metadata.DISPLAY_DESCRIPTION";
    public static final String METADATA_KEY_DISPLAY_ICON = "android.media.metadata.DISPLAY_ICON";
    public static final String METADATA_KEY_DISPLAY_ICON_URI = "android.media.metadata.DISPLAY_ICON_URI";
    public static final String METADATA_KEY_MEDIA_ID = "android.media.metadata.MEDIA_ID";
    public static final String METADATA_KEY_MEDIA_URI = "android.media.metadata.MEDIA_URI";
    public static final String METADATA_KEY_BT_FOLDER_TYPE = "android.media.metadata.BT_FOLDER_TYPE";
    static final int METADATA_TYPE_LONG = 0;
    static final int METADATA_TYPE_TEXT = 1;
    static final int METADATA_TYPE_BITMAP = 2;
    static final int METADATA_TYPE_RATING = 3;
    static final ArrayMap<String, Integer> METADATA_KEYS_TYPE = new ArrayMap();
    private static final String[] PREFERRED_DESCRIPTION_ORDER;
    private static final String[] PREFERRED_BITMAP_ORDER;
    private static final String[] PREFERRED_URI_ORDER;
    final Bundle mBundle;
    private Object mMetadataObj;
    private MediaDescriptionCompat mDescription;
    public static final Parcelable.Creator<MediaMetadataCompat> CREATOR;

    MediaMetadataCompat(Bundle bundle) {
        this.mBundle = new Bundle(bundle);
    }

    MediaMetadataCompat(Parcel in) {
        this.mBundle = in.readBundle();
    }

    public boolean containsKey(String key) {
        return this.mBundle.containsKey(key);
    }

    public CharSequence getText(String key) {
        return this.mBundle.getCharSequence(key);
    }

    public String getString(String key) {
        CharSequence text = this.mBundle.getCharSequence(key);
        if (text != null) {
            return text.toString();
        }
        return null;
    }

    public long getLong(String key) {
        return this.mBundle.getLong(key, 0L);
    }

    public RatingCompat getRating(String key) {
        RatingCompat rating = null;
        try {
            rating = Build.VERSION.SDK_INT >= 19 ? RatingCompat.fromRating(this.mBundle.getParcelable(key)) : (RatingCompat)this.mBundle.getParcelable(key);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Failed to retrieve a key as Rating.", (Throwable)e);
        }
        return rating;
    }

    public Bitmap getBitmap(String key) {
        Bitmap bmp = null;
        try {
            bmp = (Bitmap)this.mBundle.getParcelable(key);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Failed to retrieve a key as Bitmap.", (Throwable)e);
        }
        return bmp;
    }

    public MediaDescriptionCompat getDescription() {
        int i;
        if (this.mDescription != null) {
            return this.mDescription;
        }
        String mediaId = this.getString(METADATA_KEY_MEDIA_ID);
        CharSequence[] text = new CharSequence[3];
        Bitmap icon = null;
        Uri iconUri = null;
        CharSequence displayText = this.getText(METADATA_KEY_DISPLAY_TITLE);
        if (!TextUtils.isEmpty((CharSequence)displayText)) {
            text[0] = displayText;
            text[1] = this.getText(METADATA_KEY_DISPLAY_SUBTITLE);
            text[2] = this.getText(METADATA_KEY_DISPLAY_DESCRIPTION);
        } else {
            int textIndex = 0;
            int keyIndex = 0;
            while (textIndex < text.length && keyIndex < PREFERRED_DESCRIPTION_ORDER.length) {
                CharSequence next;
                if (TextUtils.isEmpty((CharSequence)(next = this.getText(PREFERRED_DESCRIPTION_ORDER[keyIndex++])))) continue;
                text[textIndex++] = next;
            }
        }
        for (i = 0; i < PREFERRED_BITMAP_ORDER.length; ++i) {
            Bitmap next = this.getBitmap(PREFERRED_BITMAP_ORDER[i]);
            if (next == null) continue;
            icon = next;
            break;
        }
        for (i = 0; i < PREFERRED_URI_ORDER.length; ++i) {
            String next = this.getString(PREFERRED_URI_ORDER[i]);
            if (TextUtils.isEmpty((CharSequence)next)) continue;
            iconUri = Uri.parse((String)next);
            break;
        }
        Uri mediaUri = null;
        String mediaUriStr = this.getString(METADATA_KEY_MEDIA_URI);
        if (!TextUtils.isEmpty((CharSequence)mediaUriStr)) {
            mediaUri = Uri.parse((String)mediaUriStr);
        }
        MediaDescriptionCompat.Builder bob = new MediaDescriptionCompat.Builder();
        bob.setMediaId(mediaId);
        bob.setTitle(text[0]);
        bob.setSubtitle(text[1]);
        bob.setDescription(text[2]);
        bob.setIconBitmap(icon);
        bob.setIconUri(iconUri);
        bob.setMediaUri(mediaUri);
        if (this.mBundle.containsKey(METADATA_KEY_BT_FOLDER_TYPE)) {
            Bundle bundle = new Bundle();
            bundle.putLong("android.media.extra.BT_FOLDER_TYPE", this.getLong(METADATA_KEY_BT_FOLDER_TYPE));
            bob.setExtras(bundle);
        }
        this.mDescription = bob.build();
        return this.mDescription;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBundle(this.mBundle);
    }

    public int size() {
        return this.mBundle.size();
    }

    public Set<String> keySet() {
        return this.mBundle.keySet();
    }

    public Bundle getBundle() {
        return this.mBundle;
    }

    public static MediaMetadataCompat fromMediaMetadata(Object metadataObj) {
        if (metadataObj == null || Build.VERSION.SDK_INT < 21) {
            return null;
        }
        Parcel p = Parcel.obtain();
        MediaMetadataCompatApi21.writeToParcel(metadataObj, p, 0);
        p.setDataPosition(0);
        MediaMetadataCompat metadata = (MediaMetadataCompat)CREATOR.createFromParcel(p);
        p.recycle();
        metadata.mMetadataObj = metadataObj;
        return metadata;
    }

    public Object getMediaMetadata() {
        if (this.mMetadataObj != null || Build.VERSION.SDK_INT < 21) {
            return this.mMetadataObj;
        }
        Parcel p = Parcel.obtain();
        this.writeToParcel(p, 0);
        p.setDataPosition(0);
        this.mMetadataObj = MediaMetadataCompatApi21.createFromParcel(p);
        p.recycle();
        return this.mMetadataObj;
    }

    static {
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_TITLE, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_ARTIST, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_DURATION, (Object)0);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_ALBUM, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_AUTHOR, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_WRITER, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_COMPOSER, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_COMPILATION, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_DATE, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_YEAR, (Object)0);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_GENRE, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_TRACK_NUMBER, (Object)0);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_NUM_TRACKS, (Object)0);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_DISC_NUMBER, (Object)0);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_ALBUM_ARTIST, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_ART, (Object)2);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_ART_URI, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_ALBUM_ART, (Object)2);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_ALBUM_ART_URI, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_USER_RATING, (Object)3);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_RATING, (Object)3);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_DISPLAY_TITLE, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_DISPLAY_SUBTITLE, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_DISPLAY_DESCRIPTION, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_DISPLAY_ICON, (Object)2);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_DISPLAY_ICON_URI, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_MEDIA_ID, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_BT_FOLDER_TYPE, (Object)0);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_MEDIA_URI, (Object)1);
        PREFERRED_DESCRIPTION_ORDER = new String[]{METADATA_KEY_TITLE, METADATA_KEY_ARTIST, METADATA_KEY_ALBUM, METADATA_KEY_ALBUM_ARTIST, METADATA_KEY_WRITER, METADATA_KEY_AUTHOR, METADATA_KEY_COMPOSER};
        PREFERRED_BITMAP_ORDER = new String[]{METADATA_KEY_DISPLAY_ICON, METADATA_KEY_ART, METADATA_KEY_ALBUM_ART};
        PREFERRED_URI_ORDER = new String[]{METADATA_KEY_DISPLAY_ICON_URI, METADATA_KEY_ART_URI, METADATA_KEY_ALBUM_ART_URI};
        CREATOR = new Parcelable.Creator<MediaMetadataCompat>(){

            public MediaMetadataCompat createFromParcel(Parcel in) {
                return new MediaMetadataCompat(in);
            }

            public MediaMetadataCompat[] newArray(int size) {
                return new MediaMetadataCompat[size];
            }
        };
    }

    public static final class Builder {
        private final Bundle mBundle;

        public Builder() {
            this.mBundle = new Bundle();
        }

        public Builder(MediaMetadataCompat source) {
            this.mBundle = new Bundle(source.mBundle);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder(MediaMetadataCompat source, int maxBitmapSize) {
            this(source);
            for (String key : this.mBundle.keySet()) {
                Object value = this.mBundle.get(key);
                if (value == null || !(value instanceof Bitmap)) continue;
                Bitmap bmp = (Bitmap)value;
                if (bmp.getHeight() > maxBitmapSize || bmp.getWidth() > maxBitmapSize) {
                    this.putBitmap(key, this.scaleBitmap(bmp, maxBitmapSize));
                    continue;
                }
                if (Build.VERSION.SDK_INT < 14 || !key.equals(MediaMetadataCompat.METADATA_KEY_ART) && !key.equals(MediaMetadataCompat.METADATA_KEY_ALBUM_ART)) continue;
                this.putBitmap(key, bmp.copy(bmp.getConfig(), false));
            }
        }

        public Builder putText(String key, CharSequence value) {
            if (METADATA_KEYS_TYPE.containsKey((Object)key) && (Integer)METADATA_KEYS_TYPE.get((Object)key) != 1) {
                throw new IllegalArgumentException("The " + key + " key cannot be used to put a CharSequence");
            }
            this.mBundle.putCharSequence(key, value);
            return this;
        }

        public Builder putString(String key, String value) {
            if (METADATA_KEYS_TYPE.containsKey((Object)key) && (Integer)METADATA_KEYS_TYPE.get((Object)key) != 1) {
                throw new IllegalArgumentException("The " + key + " key cannot be used to put a String");
            }
            this.mBundle.putCharSequence(key, (CharSequence)value);
            return this;
        }

        public Builder putLong(String key, long value) {
            if (METADATA_KEYS_TYPE.containsKey((Object)key) && (Integer)METADATA_KEYS_TYPE.get((Object)key) != 0) {
                throw new IllegalArgumentException("The " + key + " key cannot be used to put a long");
            }
            this.mBundle.putLong(key, value);
            return this;
        }

        public Builder putRating(String key, RatingCompat value) {
            if (METADATA_KEYS_TYPE.containsKey((Object)key) && (Integer)METADATA_KEYS_TYPE.get((Object)key) != 3) {
                throw new IllegalArgumentException("The " + key + " key cannot be used to put a Rating");
            }
            if (Build.VERSION.SDK_INT >= 19) {
                this.mBundle.putParcelable(key, (Parcelable)value.getRating());
            } else {
                this.mBundle.putParcelable(key, (Parcelable)value);
            }
            return this;
        }

        public Builder putBitmap(String key, Bitmap value) {
            if (METADATA_KEYS_TYPE.containsKey((Object)key) && (Integer)METADATA_KEYS_TYPE.get((Object)key) != 2) {
                throw new IllegalArgumentException("The " + key + " key cannot be used to put a Bitmap");
            }
            this.mBundle.putParcelable(key, (Parcelable)value);
            return this;
        }

        public MediaMetadataCompat build() {
            return new MediaMetadataCompat(this.mBundle);
        }

        private Bitmap scaleBitmap(Bitmap bmp, int maxSize) {
            float maxSizeF = maxSize;
            float widthScale = maxSizeF / (float)bmp.getWidth();
            float heightScale = maxSizeF / (float)bmp.getHeight();
            float scale = Math.min(widthScale, heightScale);
            int height = (int)((float)bmp.getHeight() * scale);
            int width = (int)((float)bmp.getWidth() * scale);
            return Bitmap.createScaledBitmap((Bitmap)bmp, (int)width, (int)height, (boolean)true);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface RatingKey {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface BitmapKey {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface LongKey {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface TextKey {
    }
}

