/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zzae;
import com.google.android.gms.common.internal.zzaf;
import com.google.android.gms.common.internal.zzak;
import com.google.android.gms.common.internal.zzal;
import com.google.android.gms.common.internal.zzaw;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.internal.zzn;
import com.google.android.gms.common.internal.zzo;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zze;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzd<T extends IInterface> {
    private int zzaGH;
    private long zzaGI;
    private long zzaGJ;
    private int zzaGK;
    private long zzaGL;
    private zzak zzaGM;
    private final Context mContext;
    private final Looper zzrM;
    private final zzae zzaGN;
    private final zze zzaCF;
    final Handler mHandler;
    private final Object mLock = new Object();
    private final Object zzaGO = new Object();
    private zzaw zzaGP;
    protected zzj zzaGQ;
    private T zzaGR;
    private final ArrayList<zzi<?>> zzaGS = new ArrayList();
    private zzl zzaGT;
    private int zzaGU = 1;
    private final zzf zzaGV;
    private final zzg zzaGW;
    private final int zzaGX;
    private final String zzaGY;
    private ConnectionResult zzaGZ = null;
    private boolean zzaHa = false;
    protected AtomicInteger zzaHb = new AtomicInteger(0);
    private static String[] zzaHc = new String[]{"service_esmobile", "service_googleme"};

    protected zzd(Context context, Looper looper, int n, zzf zzf2, zzg zzg2, String string2) {
        this(context, looper, zzae.zzaC(context), zze.zzoW(), n, zzbo.zzu(zzf2), zzbo.zzu(zzg2), null);
    }

    protected zzd(Context context, Looper looper, zzae zzae2, zze zze2, int n, zzf zzf2, zzg zzg2, String string2) {
        this.mContext = zzbo.zzb(context, (Object)"Context must not be null");
        this.zzrM = zzbo.zzb(looper, (Object)"Looper must not be null");
        this.zzaGN = zzbo.zzb(zzae2, (Object)"Supervisor must not be null");
        this.zzaCF = zzbo.zzb(zze2, (Object)"API availability must not be null");
        this.mHandler = new zzh(this, looper);
        this.zzaGX = n;
        this.zzaGV = zzf2;
        this.zzaGW = zzg2;
        this.zzaGY = string2;
    }

    @NonNull
    protected abstract String zzdb();

    protected String zzqZ() {
        return "com.google.android.gms";
    }

    @NonNull
    protected abstract String zzdc();

    @Nullable
    private final String zzra() {
        if (this.zzaGY == null) {
            return this.mContext.getClass().getName();
        }
        return this.zzaGY;
    }

    @Nullable
    protected abstract T zzd(IBinder var1);

    @CallSuper
    protected void zza(@NonNull T t) {
        this.zzaGJ = System.currentTimeMillis();
    }

    @CallSuper
    protected final void onConnectionSuspended(int n) {
        this.zzaGH = n;
        this.zzaGI = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionFailed(ConnectionResult connectionResult) {
        this.zzaGK = connectionResult.getErrorCode();
        this.zzaGL = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(int n, T t) {
        zzbo.zzaf(n == 4 == (t != null));
        Object object = this.mLock;
        synchronized (object) {
            this.zzaGU = n;
            this.zzaGR = t;
            switch (n) {
                case 2: 
                case 3: {
                    String string2;
                    zzd zzd2 = this;
                    if (zzd2.zzaGT != null && zzd2.zzaGM != null) {
                        String string3 = String.valueOf(zzd2.zzaGM.zzrE());
                        string2 = String.valueOf(zzd2.zzaGM.getPackageName());
                        Log.e((String)"GmsClient", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Calling connect() while still connected, missing disconnect() for ").append(string3).append(" on ").append(string2).toString());
                        zzd2.zzaGN.zza(zzd2.zzaGM.zzrE(), zzd2.zzaGM.getPackageName(), zzd2.zzaGT, zzd2.zzra());
                        zzd2.zzaHb.incrementAndGet();
                    }
                    zzd2.zzaGT = new zzl(zzd2, zzd2.zzaHb.get());
                    zzd zzd3 = zzd2;
                    zzd2.zzaGM = new zzak(zzd3.zzqZ(), zzd3.zzdb(), false);
                    String string4 = zzd2.zzra();
                    zzl zzl2 = zzd2.zzaGT;
                    String string5 = zzd2.zzaGM.getPackageName();
                    String string6 = zzd2.zzaGM.zzrE();
                    if (zzd2.zzaGN.zza(new zzaf(string6, string5), (ServiceConnection)zzl2, string4)) break;
                    string2 = String.valueOf(zzd2.zzaGM.zzrE());
                    String string7 = String.valueOf(zzd2.zzaGM.getPackageName());
                    Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string7).length()).append("unable to connect to service: ").append(string2).append(" on ").append(string7).toString());
                    zzd2.zza(16, null, zzd2.zzaHb.get());
                    break;
                }
                case 4: {
                    this.zza(t);
                    break;
                }
                case 1: {
                    zzd zzd4 = this;
                    if (zzd4.zzaGT == null) break;
                    zzd4.zzaGN.zza(zzd4.zzdb(), zzd4.zzqZ(), zzd4.zzaGT, zzd4.zzra());
                    zzd4.zzaGT = null;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(int n, int n2, T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzaGU != n) {
                return false;
            }
            this.zza(n2, t);
            return true;
        }
    }

    public final void zzrb() {
        int n = this.zzaCF.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            this.zza(1, null);
            this.zza(new zzm(this), n, null);
            return;
        }
        this.zza(new zzm(this));
    }

    public void zza(@NonNull zzj zzj2) {
        this.zzaGQ = zzbo.zzb(zzj2, (Object)"Connection progress callbacks cannot be null.");
        this.zza(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnected() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzaGU == 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnecting() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzaGU == 2 || this.zzaGU == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zzrc() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzaGU == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.zzaHb.incrementAndGet();
        Object object = this.zzaGS;
        synchronized (object) {
            int n = this.zzaGS.size();
            for (int i = 0; i < n; ++i) {
                this.zzaGS.get(i).removeListener();
            }
            this.zzaGS.clear();
        }
        object = this.zzaGO;
        synchronized (object) {
            this.zzaGP = null;
        }
        this.zza(1, null);
    }

    public final void zzay(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, this.zzaHb.get(), n));
    }

    private final void zzaz(int n) {
        int n2;
        if (this.zzrc()) {
            n2 = 5;
            this.zzaHa = true;
        } else {
            n2 = 4;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(n2, this.zzaHb.get(), 16));
    }

    protected final void zza(@NonNull zzj zzj2, int n, @Nullable PendingIntent pendingIntent) {
        this.zzaGQ = zzbo.zzb(zzj2, (Object)"Connection progress callbacks cannot be null.");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzaHb.get(), n, (Object)pendingIntent));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.zzrM;
    }

    public Account getAccount() {
        return null;
    }

    public zzc[] zzrd() {
        return new zzc[0];
    }

    protected Bundle zzmo() {
        return new Bundle();
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzn(this, n, iBinder, bundle)));
    }

    protected final void zza(int n, @Nullable Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, n2, -1, (Object)new zzo(this, n, null)));
    }

    protected final void zzre() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    public Bundle zzoC() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T zzrf() throws DeadObjectException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzaGU == 5) {
                throw new DeadObjectException();
            }
            this.zzre();
            zzbo.zza(this.zzaGR != null, (Object)"Client is connected but service is null");
            return this.zzaGR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(zzal zzal2, Set<Scope> set) {
        Bundle bundle = this.zzmo();
        Object object = this.mContext.getPackageName();
        Object object2 = new zzx(this.zzaGX);
        new zzx(this.zzaGX).zzaHw = object;
        object = bundle;
        v0.zzaHz = object;
        zzx zzx2 = object2;
        if (set != null) {
            object = set;
            zzx2.zzaHy = object.toArray(new Scope[object.size()]);
        }
        if (this.zzmv()) {
            object2 = this;
            object = ((zzd)object2).getAccount() != null ? ((zzd)object2).getAccount() : new Account("<<default account>>", "com.google");
            object2 = zzx2;
            zzx2.zzaHA = object;
            object = zzal2;
            if (object != null) {
                ((zzx)object2).zzaHx = object.asBinder();
            }
        } else if (this.zzrg()) {
            zzx2.zzaHA = object = this.getAccount();
        }
        object = this.zzrd();
        zzx2.zzaHB = object;
        try {
            Object object3 = this.zzaGO;
            synchronized (object3) {
                if (this.zzaGP != null) {
                    this.zzaGP.zza(new zzk(this, this.zzaHb.get()), zzx2);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
                return;
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)deadObjectException);
            this.zzay(1);
            return;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (RemoteException | RuntimeException throwable) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)throwable);
            this.zza(8, null, null, this.zzaHb.get());
            return;
        }
    }

    public boolean zzmv() {
        return false;
    }

    public boolean zzrg() {
        return false;
    }

    public boolean zzpe() {
        return true;
    }

    public boolean zzmG() {
        return false;
    }

    public Intent zzmH() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    protected Set<Scope> zzrh() {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3;
        long l;
        zzaw zzaw2;
        T t;
        int n;
        Object object = this.mLock;
        synchronized (object) {
            n = this.zzaGU;
            t = this.zzaGR;
        }
        object = this.zzaGO;
        synchronized (object) {
            zzaw2 = this.zzaGP;
        }
        printWriter.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                printWriter.print("REMOTE_CONNECTING");
                break;
            }
            case 3: {
                printWriter.print("LOCAL_CONNECTING");
                break;
            }
            case 4: {
                printWriter.print("CONNECTED");
                break;
            }
            case 5: {
                printWriter.print("DISCONNECTING");
                break;
            }
            case 1: {
                printWriter.print("DISCONNECTED");
                break;
            }
            default: {
                printWriter.print("UNKNOWN");
            }
        }
        printWriter.append(" mService=");
        if (t == null) {
            printWriter.append("null");
        } else {
            printWriter.append(this.zzdc()).append("@").append(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        printWriter.append(" mServiceBroker=");
        if (zzaw2 == null) {
            printWriter.println("null");
        } else {
            printWriter.append("IGmsServiceBroker@").println(Integer.toHexString(System.identityHashCode(zzaw2.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.zzaGJ > 0L) {
            l = this.zzaGJ;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.zzaGJ)));
            printWriter.append(string2).append("lastConnectedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzaGI > 0L) {
            printWriter.append(string2).append("lastSuspendedCause=");
            switch (this.zzaGH) {
                case 1: {
                    printWriter.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 2: {
                    printWriter.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    printWriter.append(String.valueOf(this.zzaGH));
                }
            }
            l = this.zzaGI;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.zzaGI)));
            printWriter.append(" lastSuspendedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzaGL > 0L) {
            printWriter.append(string2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.zzaGK));
            l = this.zzaGL;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.zzaGL)));
            printWriter.append(" lastFailedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
    }

    private final boolean zzri() {
        if (this.zzaHa) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzdc())) {
            return false;
        }
        if (TextUtils.isEmpty(null)) {
            return false;
        }
        try {
            Class.forName(this.zzdc());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    static /* synthetic */ void zza(zzd zzd2, int n) {
        zzd2.zzaz(16);
    }

    static /* synthetic */ Object zza(zzd zzd2) {
        return zzd2.zzaGO;
    }

    static /* synthetic */ zzaw zza(zzd zzd2, zzaw zzaw2) {
        zzd2.zzaGP = zzaw2;
        return zzd2.zzaGP;
    }

    static /* synthetic */ ConnectionResult zza(zzd zzd2, ConnectionResult connectionResult) {
        zzd2.zzaGZ = connectionResult;
        return zzd2.zzaGZ;
    }

    static /* synthetic */ boolean zzb(zzd zzd2) {
        return zzd2.zzri();
    }

    static /* synthetic */ boolean zzc(zzd zzd2) {
        return zzd2.zzaHa;
    }

    static /* synthetic */ void zza(zzd zzd2, int n, IInterface iInterface) {
        zzd2.zza(n, null);
    }

    static /* synthetic */ ConnectionResult zzd(zzd zzd2) {
        return zzd2.zzaGZ;
    }

    static /* synthetic */ zzf zze(zzd zzd2) {
        return zzd2.zzaGV;
    }

    static /* synthetic */ boolean zza(zzd zzd2, int n, int n2, IInterface iInterface) {
        return zzd2.zza(n, n2, iInterface);
    }

    static /* synthetic */ ArrayList zzf(zzd zzd2) {
        return zzd2.zzaGS;
    }

    static /* synthetic */ zzg zzg(zzd zzd2) {
        return zzd2.zzaGW;
    }
}

