/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.content.Context;
import android.os.Build;
import android.view.ViewGroup;
import android.widget.EditText;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.text.ReactBaseTextShadowNode;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.textinput.ReactTextInputLocalData;
import com.facebook.react.views.view.MeasureUtil;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import com.facebook.yoga.YogaNode;
import javax.annotation.Nullable;

@VisibleForTesting
public class ReactTextInputShadowNode
extends ReactBaseTextShadowNode
implements YogaMeasureFunction {
    private int mMostRecentEventCount = -1;
    @Nullable
    private EditText mDummyEditText;
    @Nullable
    private ReactTextInputLocalData mLocalData;
    @VisibleForTesting
    public static final String PROP_TEXT = "text";
    @Nullable
    private String mText = null;

    public ReactTextInputShadowNode() {
        this.mTextBreakStrategy = Build.VERSION.SDK_INT < 23 ? 0 : 0;
        this.setMeasureFunction(this);
    }

    @Override
    public void setThemedContext(ThemedReactContext themedContext) {
        super.setThemedContext(themedContext);
        EditText editText = new EditText((Context)this.getThemedContext());
        this.setDefaultPadding(4, editText.getPaddingStart());
        this.setDefaultPadding(1, editText.getPaddingTop());
        this.setDefaultPadding(5, editText.getPaddingEnd());
        this.setDefaultPadding(3, editText.getPaddingBottom());
        this.mDummyEditText = editText;
        this.mDummyEditText.setPadding(0, 0, 0, 0);
        this.mDummyEditText.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
    }

    @Override
    public long measure(YogaNode node, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
        EditText editText = (EditText)Assertions.assertNotNull((Object)this.mDummyEditText);
        if (this.mLocalData == null) {
            return YogaMeasureOutput.make(0, 0);
        }
        this.mLocalData.apply(editText);
        editText.measure(MeasureUtil.getMeasureSpec(width, widthMode), MeasureUtil.getMeasureSpec(height, heightMode));
        return YogaMeasureOutput.make(editText.getMeasuredWidth(), editText.getMeasuredHeight());
    }

    @Override
    public boolean isVirtualAnchor() {
        return true;
    }

    @Override
    public boolean isYogaLeafNode() {
        return true;
    }

    @Override
    public void setLocalData(Object data) {
        Assertions.assertCondition((boolean)(data instanceof ReactTextInputLocalData));
        this.mLocalData = (ReactTextInputLocalData)data;
        this.dirty();
    }

    @ReactProp(name="mostRecentEventCount")
    public void setMostRecentEventCount(int mostRecentEventCount) {
        this.mMostRecentEventCount = mostRecentEventCount;
    }

    @ReactProp(name="text")
    public void setText(@Nullable String text) {
        this.mText = text;
        this.markUpdated();
    }

    @Nullable
    public String getText() {
        return this.mText;
    }

    @Override
    public void setTextBreakStrategy(@Nullable String textBreakStrategy) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        if (textBreakStrategy == null || "simple".equals(textBreakStrategy)) {
            this.mTextBreakStrategy = 0;
        } else if ("highQuality".equals(textBreakStrategy)) {
            this.mTextBreakStrategy = 1;
        } else if ("balanced".equals(textBreakStrategy)) {
            this.mTextBreakStrategy = 2;
        } else {
            throw new JSApplicationIllegalArgumentException("Invalid textBreakStrategy: " + textBreakStrategy);
        }
    }

    @Override
    public void onCollectExtraUpdates(UIViewOperationQueue uiViewOperationQueue) {
        super.onCollectExtraUpdates(uiViewOperationQueue);
        if (this.mMostRecentEventCount != -1) {
            ReactTextUpdate reactTextUpdate = new ReactTextUpdate(ReactTextInputShadowNode.spannedFromShadowNode(this, this.getText()), this.mMostRecentEventCount, this.mContainsImages, this.getPadding(0), this.getPadding(1), this.getPadding(2), this.getPadding(3), this.mTextAlign, this.mTextBreakStrategy);
            uiViewOperationQueue.enqueueUpdateExtraData(this.getReactTag(), reactTextUpdate);
        }
    }

    @Override
    public void setPadding(int spacingType, float padding) {
        super.setPadding(spacingType, padding);
        this.markUpdated();
    }
}

