/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.content.Context;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.react.flat.AttachDetachListener;
import com.facebook.react.flat.DrawCommand;
import com.facebook.react.flat.FlatRootViewManager;
import com.facebook.react.flat.FlatViewGroup;
import com.facebook.react.flat.NodeRegion;
import com.facebook.react.flat.ViewResolver;
import com.facebook.react.uimanager.NativeViewHierarchyManager;
import com.facebook.react.uimanager.SizeMonitoringFrameLayout;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.ViewManagerRegistry;
import java.util.ArrayList;
import javax.annotation.Nullable;

final class FlatNativeViewHierarchyManager
extends NativeViewHierarchyManager
implements ViewResolver {
    FlatNativeViewHierarchyManager(ViewManagerRegistry viewManagers) {
        super(viewManagers, new FlatRootViewManager());
    }

    @Override
    public View getView(int reactTag) {
        return super.resolveView(reactTag);
    }

    @Override
    public void addRootView(int tag, SizeMonitoringFrameLayout view, ThemedReactContext themedContext) {
        FlatViewGroup root = new FlatViewGroup((Context)themedContext);
        view.addView((View)root);
        view.setId(tag);
        this.addRootViewGroup(tag, root, themedContext);
    }

    void updateMountState(int reactTag, @Nullable DrawCommand[] drawCommands, @Nullable AttachDetachListener[] listeners, @Nullable NodeRegion[] nodeRegions) {
        FlatViewGroup view = (FlatViewGroup)this.resolveView(reactTag);
        if (drawCommands != null) {
            view.mountDrawCommands(drawCommands);
        }
        if (listeners != null) {
            view.mountAttachDetachListeners(listeners);
        }
        if (nodeRegions != null) {
            view.mountNodeRegions(nodeRegions);
        }
    }

    void updateClippingMountState(int reactTag, @Nullable DrawCommand[] drawCommands, SparseIntArray drawViewIndexMap, float[] commandMaxBot, float[] commandMinTop, @Nullable AttachDetachListener[] listeners, @Nullable NodeRegion[] nodeRegions, float[] regionMaxBot, float[] regionMinTop, boolean willMountViews) {
        FlatViewGroup view = (FlatViewGroup)this.resolveView(reactTag);
        if (drawCommands != null) {
            view.mountClippingDrawCommands(drawCommands, drawViewIndexMap, commandMaxBot, commandMinTop, willMountViews);
        }
        if (listeners != null) {
            view.mountAttachDetachListeners(listeners);
        }
        if (nodeRegions != null) {
            view.mountClippingNodeRegions(nodeRegions, regionMaxBot, regionMinTop);
        }
    }

    void updateViewGroup(int reactTag, int[] viewsToAdd, int[] viewsToDetach) {
        View view = this.resolveView(reactTag);
        if (view instanceof FlatViewGroup) {
            ((FlatViewGroup)view).mountViews(this, viewsToAdd, viewsToDetach);
            return;
        }
        ViewGroup viewGroup = (ViewGroup)view;
        ViewGroupManager viewManager = (ViewGroupManager)this.resolveViewManager(reactTag);
        ArrayList<View> listOfViews = new ArrayList<View>(viewsToAdd.length);
        for (int viewIdToAdd : viewsToAdd) {
            int tag = Math.abs(viewIdToAdd);
            listOfViews.add(this.resolveView(tag));
        }
        viewManager.addViews(viewGroup, listOfViews);
    }

    void updateViewBounds(int reactTag, int left, int top, int right, int bottom) {
        View view = this.resolveView(reactTag);
        int width = right - left;
        int height = bottom - top;
        if (view.getWidth() != width || view.getHeight() != height) {
            view.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
            view.layout(left, top, right, bottom);
        } else {
            view.offsetLeftAndRight(left - view.getLeft());
            view.offsetTopAndBottom(top - view.getTop());
        }
    }

    void setPadding(int reactTag, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.resolveView(reactTag).setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
    }

    void dropViews(SparseIntArray viewsToDrop) {
        int count = viewsToDrop.size();
        for (int i = 0; i < count; ++i) {
            View parent;
            int viewToDrop = viewsToDrop.keyAt(i);
            View view = null;
            if (viewToDrop > 0) {
                try {
                    view = this.resolveView(viewToDrop);
                    this.dropView(view);
                }
                catch (Exception exception) {}
            } else {
                this.removeRootView(-viewToDrop);
            }
            int parentTag = viewsToDrop.valueAt(i);
            if (parentTag <= 0 || view == null || view.getParent() != null || !((parent = this.resolveView(parentTag)) instanceof FlatViewGroup)) continue;
            ((FlatViewGroup)parent).onViewDropped(view);
        }
    }

    @Override
    protected void dropView(View view) {
        FlatViewGroup flatViewGroup;
        super.dropView(view);
        if (view instanceof FlatViewGroup && (flatViewGroup = (FlatViewGroup)view).getRemoveClippedSubviews()) {
            SparseArray<View> detachedViews = flatViewGroup.getDetachedViews();
            int size = detachedViews.size();
            for (int i = 0; i < size; ++i) {
                View detachedChild = (View)detachedViews.valueAt(i);
                try {
                    this.dropView(detachedChild);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                flatViewGroup.removeDetachedView(detachedChild);
            }
        }
    }

    void detachAllChildrenFromViews(int[] viewsToDetachAllChildrenFrom) {
        for (int viewTag : viewsToDetachAllChildrenFrom) {
            View view = this.resolveView(viewTag);
            if (view instanceof FlatViewGroup) {
                ((FlatViewGroup)view).detachAllViewsFromParent();
                continue;
            }
            ViewGroup viewGroup = (ViewGroup)view;
            ViewGroupManager viewManager = (ViewGroupManager)this.resolveViewManager(viewTag);
            viewManager.removeAllViews(viewGroup);
        }
    }
}

