/*
 * Decompiled with CFR 0.152.
 */
package com.learnium.RNDeviceInfo;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.format.DateFormat;
import android.text.format.Formatter;
import android.util.DisplayMetrics;
import android.webkit.WebSettings;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.google.android.gms.iid.InstanceID;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nullable;

public class RNDeviceModule
extends ReactContextBaseJavaModule {
    ReactApplicationContext reactContext;
    WifiInfo wifiInfo;

    public RNDeviceModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.reactContext = reactContext;
    }

    public String getName() {
        return "RNDeviceInfo";
    }

    private WifiInfo getWifiInfo() {
        if (this.wifiInfo == null) {
            WifiManager manager = (WifiManager)this.reactContext.getApplicationContext().getSystemService("wifi");
            this.wifiInfo = manager.getConnectionInfo();
        }
        return this.wifiInfo;
    }

    private String getCurrentLanguage() {
        Locale current = this.getReactApplicationContext().getResources().getConfiguration().locale;
        if (Build.VERSION.SDK_INT >= 21) {
            return current.toLanguageTag();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(current.getLanguage());
        if (current.getCountry() != null) {
            builder.append("-");
            builder.append(current.getCountry());
        }
        return builder.toString();
    }

    private String getCurrentCountry() {
        Locale current = this.getReactApplicationContext().getResources().getConfiguration().locale;
        return current.getCountry();
    }

    private Boolean isEmulator() {
        return Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
    }

    private Boolean isTablet() {
        int layout = this.getReactApplicationContext().getResources().getConfiguration().screenLayout & 0xF;
        if (layout != 3 && layout != 4) {
            return false;
        }
        DisplayMetrics metrics = this.getReactApplicationContext().getResources().getDisplayMetrics();
        if (metrics.densityDpi == 160 || metrics.densityDpi == 240 || metrics.densityDpi == 160 || metrics.densityDpi == 213 || metrics.densityDpi == 320) {
            return true;
        }
        return false;
    }

    private float fontScale() {
        return this.getReactApplicationContext().getResources().getConfiguration().fontScale;
    }

    private Boolean is24Hour() {
        return DateFormat.is24HourFormat((Context)this.reactContext.getApplicationContext());
    }

    @ReactMethod
    public void isPinOrFingerprintSet(Callback callback) {
        KeyguardManager keyguardManager = (KeyguardManager)this.reactContext.getApplicationContext().getSystemService("keyguard");
        callback.invoke(new Object[]{keyguardManager.isKeyguardSecure()});
    }

    @ReactMethod
    public void getIpAddress(Promise p) {
        String ipAddress = Formatter.formatIpAddress((int)this.getWifiInfo().getIpAddress());
        p.resolve((Object)ipAddress);
    }

    @ReactMethod
    public void getMacAddress(Promise p) {
        String macAddress = this.getWifiInfo().getMacAddress();
        String permission2 = "android.permission.INTERNET";
        int res = this.reactContext.checkCallingOrSelfPermission(permission2);
        if (res == 0) {
            try {
                ArrayList<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
                for (NetworkInterface nif : all) {
                    if (!nif.getName().equalsIgnoreCase("wlan0")) continue;
                    byte[] macBytes = nif.getHardwareAddress();
                    if (macBytes == null) {
                        macAddress = "";
                        continue;
                    }
                    StringBuilder res1 = new StringBuilder();
                    for (byte b : macBytes) {
                        res1.append(String.format("%02X:", b));
                    }
                    if (res1.length() > 0) {
                        res1.deleteCharAt(res1.length() - 1);
                    }
                    macAddress = res1.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        p.resolve((Object)macAddress);
    }

    @ReactMethod
    public String getCarrier() {
        TelephonyManager telMgr = (TelephonyManager)this.reactContext.getSystemService("phone");
        return telMgr.getNetworkOperatorName();
    }

    @ReactMethod
    public Integer getTotalDiskCapacity() {
        try {
            StatFs root = new StatFs(Environment.getRootDirectory().getAbsolutePath());
            return root.getBlockCount() * root.getBlockSize();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @ReactMethod
    public Integer getFreeDiskStorage() {
        try {
            StatFs external = new StatFs(Environment.getExternalStorageDirectory().getAbsolutePath());
            return external.getAvailableBlocks() * external.getBlockSize();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @ReactMethod
    public void getBatteryLevel(Promise p) {
        Intent batteryIntent = this.reactContext.getApplicationContext().registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        int level = batteryIntent.getIntExtra("level", -1);
        int scale = batteryIntent.getIntExtra("scale", -1);
        float batteryLevel = (float)level / (float)scale;
        p.resolve((Object)Float.valueOf(batteryLevel));
    }

    public String getInstallReferrer() {
        SharedPreferences sharedPref = this.getReactApplicationContext().getSharedPreferences("react-native-device-info", 0);
        return sharedPref.getString("installReferrer", null);
    }

    @Nullable
    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        PackageManager packageManager = this.reactContext.getPackageManager();
        String packageName = this.reactContext.getPackageName();
        constants.put("appVersion", "not available");
        constants.put("appName", "not available");
        constants.put("buildVersion", "not available");
        constants.put("buildNumber", 0);
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
            PackageInfo info = packageManager.getPackageInfo(packageName, 0);
            String applicationName = this.reactContext.getApplicationInfo().loadLabel(this.reactContext.getPackageManager()).toString();
            constants.put("appVersion", info.versionName);
            constants.put("buildNumber", info.versionCode);
            constants.put("firstInstallTime", info.firstInstallTime);
            constants.put("lastUpdateTime", info.lastUpdateTime);
            constants.put("appName", applicationName);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        String deviceName = "Unknown";
        String permission2 = "android.permission.BLUETOOTH";
        int res = this.reactContext.checkCallingOrSelfPermission(permission2);
        if (res == 0) {
            try {
                BluetoothAdapter myDevice = BluetoothAdapter.getDefaultAdapter();
                if (myDevice != null) {
                    deviceName = myDevice.getName();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            if (Class.forName("com.google.android.gms.iid.InstanceID") != null) {
                constants.put("instanceId", InstanceID.getInstance((Context)this.reactContext).getId());
            }
        }
        catch (ClassNotFoundException e) {
            constants.put("instanceId", "N/A: Add com.google.android.gms:play-services-gcm to your project.");
        }
        constants.put("serialNumber", Build.SERIAL);
        constants.put("deviceName", deviceName);
        constants.put("systemName", "Android");
        constants.put("systemVersion", Build.VERSION.RELEASE);
        constants.put("model", Build.MODEL);
        constants.put("brand", Build.BRAND);
        constants.put("deviceId", Build.BOARD);
        constants.put("apiLevel", Build.VERSION.SDK_INT);
        constants.put("deviceLocale", this.getCurrentLanguage());
        constants.put("deviceCountry", this.getCurrentCountry());
        constants.put("uniqueId", Settings.Secure.getString((ContentResolver)this.reactContext.getContentResolver(), (String)"android_id"));
        constants.put("systemManufacturer", Build.MANUFACTURER);
        constants.put("bundleId", packageName);
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                constants.put("userAgent", WebSettings.getDefaultUserAgent((Context)this.reactContext));
            }
            catch (RuntimeException e) {
                constants.put("userAgent", System.getProperty("http.agent"));
            }
        }
        constants.put("timezone", TimeZone.getDefault().getID());
        constants.put("isEmulator", this.isEmulator());
        constants.put("isTablet", this.isTablet());
        constants.put("fontScale", Float.valueOf(this.fontScale()));
        constants.put("is24Hour", this.is24Hour());
        if (this.getCurrentActivity() != null && (this.getCurrentActivity().checkCallingOrSelfPermission("android.permission.READ_PHONE_STATE") == 0 || this.getCurrentActivity().checkCallingOrSelfPermission("android.permission.READ_SMS") == 0 || this.getCurrentActivity().checkCallingOrSelfPermission("android.permission.READ_PHONE_NUMBERS") == 0)) {
            TelephonyManager telMgr = (TelephonyManager)this.reactContext.getApplicationContext().getSystemService("phone");
            constants.put("phoneNumber", telMgr.getLine1Number());
        }
        constants.put("carrier", this.getCarrier());
        constants.put("totalDiskCapacity", this.getTotalDiskCapacity());
        constants.put("freeDiskStorage", this.getFreeDiskStorage());
        constants.put("installReferrer", this.getInstallReferrer());
        Runtime rt = Runtime.getRuntime();
        constants.put("maxMemory", rt.maxMemory());
        ActivityManager actMgr = (ActivityManager)this.reactContext.getSystemService("activity");
        ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
        actMgr.getMemoryInfo(memInfo);
        constants.put("totalMemory", memInfo.totalMem);
        return constants;
    }
}

