/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.file;

import com.facebook.common.file.FileTreeVisitor;
import java.io.File;

public class FileTree {
    public static void walkFileTree(File directory, FileTreeVisitor visitor) {
        visitor.preVisitDirectory(directory);
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    FileTree.walkFileTree(file, visitor);
                    continue;
                }
                visitor.visitFile(file);
            }
        }
        visitor.postVisitDirectory(directory);
    }

    public static boolean deleteContents(File directory) {
        File[] files = directory.listFiles();
        boolean success = true;
        if (files != null) {
            for (File file : files) {
                success &= FileTree.deleteRecursively(file);
            }
        }
        return success;
    }

    public static boolean deleteRecursively(File file) {
        if (file.isDirectory()) {
            FileTree.deleteContents(file);
        }
        return file.delete();
    }
}

