/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.backends.pipeline;

import android.content.Context;
import android.net.Uri;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.Supplier;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.DataSource;
import com.facebook.drawee.backends.pipeline.PipelineDraweeController;
import com.facebook.drawee.backends.pipeline.PipelineDraweeControllerFactory;
import com.facebook.drawee.controller.AbstractDraweeControllerBuilder;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.common.RotationOptions;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.ImageInfo;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import java.util.Set;
import javax.annotation.Nullable;

public class PipelineDraweeControllerBuilder
extends AbstractDraweeControllerBuilder<PipelineDraweeControllerBuilder, ImageRequest, CloseableReference<CloseableImage>, ImageInfo> {
    private final ImagePipeline mImagePipeline;
    private final PipelineDraweeControllerFactory mPipelineDraweeControllerFactory;

    public PipelineDraweeControllerBuilder(Context context, PipelineDraweeControllerFactory pipelineDraweeControllerFactory, ImagePipeline imagePipeline, Set<ControllerListener> boundControllerListeners) {
        super(context, boundControllerListeners);
        this.mImagePipeline = imagePipeline;
        this.mPipelineDraweeControllerFactory = pipelineDraweeControllerFactory;
    }

    public PipelineDraweeControllerBuilder setUri(@Nullable Uri uri) {
        if (uri == null) {
            return (PipelineDraweeControllerBuilder)super.setImageRequest(null);
        }
        ImageRequest imageRequest = ImageRequestBuilder.newBuilderWithSource((Uri)uri).setRotationOptions(RotationOptions.autoRotateAtRenderTime()).build();
        return (PipelineDraweeControllerBuilder)super.setImageRequest((Object)imageRequest);
    }

    public PipelineDraweeControllerBuilder setUri(@Nullable String uriString) {
        if (uriString == null || uriString.isEmpty()) {
            return (PipelineDraweeControllerBuilder)super.setImageRequest((Object)ImageRequest.fromUri((String)uriString));
        }
        return this.setUri(Uri.parse((String)uriString));
    }

    protected PipelineDraweeController obtainController() {
        PipelineDraweeController controller;
        DraweeController oldController = this.getOldController();
        if (oldController instanceof PipelineDraweeController) {
            controller = (PipelineDraweeController)oldController;
            controller.initialize((Supplier<DataSource<CloseableReference<CloseableImage>>>)this.obtainDataSourceSupplier(), PipelineDraweeControllerBuilder.generateUniqueControllerId(), this.getCacheKey(), this.getCallerContext());
        } else {
            controller = this.mPipelineDraweeControllerFactory.newController((Supplier<DataSource<CloseableReference<CloseableImage>>>)this.obtainDataSourceSupplier(), PipelineDraweeControllerBuilder.generateUniqueControllerId(), this.getCacheKey(), this.getCallerContext());
        }
        return controller;
    }

    private CacheKey getCacheKey() {
        ImageRequest imageRequest = (ImageRequest)this.getImageRequest();
        CacheKeyFactory cacheKeyFactory = this.mImagePipeline.getCacheKeyFactory();
        CacheKey cacheKey = null;
        if (cacheKeyFactory != null && imageRequest != null) {
            cacheKey = imageRequest.getPostprocessor() != null ? cacheKeyFactory.getPostprocessedBitmapCacheKey(imageRequest, this.getCallerContext()) : cacheKeyFactory.getBitmapCacheKey(imageRequest, this.getCallerContext());
        }
        return cacheKey;
    }

    protected DataSource<CloseableReference<CloseableImage>> getDataSourceForRequest(ImageRequest imageRequest, Object callerContext, AbstractDraweeControllerBuilder.CacheLevel cacheLevel) {
        return this.mImagePipeline.fetchDecodedImage(imageRequest, callerContext, PipelineDraweeControllerBuilder.convertCacheLevelToRequestLevel(cacheLevel));
    }

    protected PipelineDraweeControllerBuilder getThis() {
        return this;
    }

    public static ImageRequest.RequestLevel convertCacheLevelToRequestLevel(AbstractDraweeControllerBuilder.CacheLevel cacheLevel) {
        switch (cacheLevel) {
            case FULL_FETCH: {
                return ImageRequest.RequestLevel.FULL_FETCH;
            }
            case DISK_CACHE: {
                return ImageRequest.RequestLevel.DISK_CACHE;
            }
            case BITMAP_MEMORY_CACHE: {
                return ImageRequest.RequestLevel.BITMAP_MEMORY_CACHE;
            }
        }
        throw new RuntimeException("Cache level" + cacheLevel + "is not supported. ");
    }
}

