var webpackRequire = require("./webpack-require");
webpackRequire(
"./src/app.js",
{

/***/ "./src/app.js":
/*!********************!*\
  !*** ./src/app.js ***!
  \********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

//app.js
const WeimobJsSdk = __webpack_require__(/*! ./utils/weimob-js-sdk/index */ "./src/utils/weimob-js-sdk/index.js");
const weimobJsSdk = new WeimobJsSdk();
App({
  onLaunch: function () {
    var logs = wx.getStorageSync('logs') || [];
    logs.unshift(Date.now());
    wx.setStorageSync('logs', logs);
    wx.getSystemInfo({
      success: result => {
        console.log(result);
        this.globalData.systemInfo = result;
      }
    });
    wx.customTheme = {
      "color": "color:#86B902;",
      "bgc": "background-color: #86B902;",
      "bdc": "border-color: #86B902;",
      "bgCart": "background-color: #454552;",
      "bgcOpacity": "background-color: rgba(134,185,2,0.7);",
      "colorStr": "#86B902"
    };
    wx.currency = {
      "symbol": "¥",
      "name": "元",
      "unit": "元"
    };
  },
  getSdkSync() {
    return Promise.resolve(weimobJsSdk);
  },
  getSdk() {
    return weimobJsSdk;
  },
  globalData: {
    userInfo: null
  }
});

/***/ }),

/***/ "./src/utils/weimob-js-sdk/index.js":
/*!******************************************!*\
  !*** ./src/utils/weimob-js-sdk/index.js ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// import retailApi from './utils/retail.api'
const EXTENDS_PAGE_LIST = ['pages/goods/detail', 'pages/goods/searchResult/index', 'pages/shop/cart', 'pages/order/create/index', 'pages/order/detail/paidstatus', 'pages/order/detail/detail', 'pages/user/guide/myguide', 'pages/user/membership/index', 'pages/tabbar/goods/list', 'pages/tabbar/goods/classify', 'pages/tabbar/user/center'];
const {
  login,
  loginByPhone
} = __webpack_require__(/*! ./utils/auth */ "./src/utils/weimob-js-sdk/utils/auth.js");
const WeimobCore = __webpack_require__(/*! ./utils/core */ "./src/utils/weimob-js-sdk/utils/core.js");
const request = __webpack_require__(/*! ./utils/request */ "./src/utils/weimob-js-sdk/utils/request.js");
const {
  relationChain,
  userPhone
} = __webpack_require__(/*! ./utils/paas */ "./src/utils/weimob-js-sdk/utils/paas.js");
const navigator = __webpack_require__(/*! ./utils/navigator */ "./src/utils/weimob-js-sdk/utils/navigator.js");
const retailApi = __webpack_require__(/*! ./utils/retail.api */ "./src/utils/weimob-js-sdk/utils/retail.api.js");
const {
  downloadFile
} = __webpack_require__(/*! ./utils/file */ "./src/utils/weimob-js-sdk/utils/file.js");
class WeimobJsSdk {
  constructor() {
    this.login = login;
    this.loginByPhone = loginByPhone;
    this.pages = {};
    this.request = request;
    this.toPage = navigator;
    this._globalData = {};
    this.getRetailData = retailApi; // 此处暴露公共数据获取接口
    this.relationChain = relationChain; // 导购存关系链
    this.userPhone = userPhone; // 会员注册手机号
    this.downloadFile = downloadFile;
    this.getStoreId = () => 123456; // 获取storeId
    this.setStoreId = () => {}; // 设置storeId
    this.recommendStoreId = () => Promise.resolve({
      errcode: '0',
      errmsg: '处理成功',
      data: {
        url: 'https://100000199446.retail.n.weimob.com/saas/retail/100000199446/26051446/shop/store/preprocess',
        isNewRetailMode: true,
        recommendStoreResultInfo: '',
        storeId: 26051446
      }
    }); // 简易版门店推荐
    this.jumpToStoreList = url => console.log('真实环境会跳转到门店列表'); // 跳转门店列表， url为回跳地址

    Object.defineProperty(this, 'page', {
      get() {
        return this.$getCurrentPage();
      }
    });
  }
  $getCurrentPage() {
    const pages = getCurrentPages();
    const page = pages[pages.length - 1];
    if (page) {
      if (EXTENDS_PAGE_LIST.indexOf(page.route) >= 0 && !page.core) {
        page.core = new WeimobCore(page);
      }
      return page.core;
    }
  }
  $setGlobalData(key, value) {
    this._globalData[key] = value;
  }
  $getGlobalData(key) {
    return this._globalData[key];
  }
}
module.exports = WeimobJsSdk;

/***/ }),

/***/ "./src/utils/weimob-js-sdk/utils/auth.js":
/*!***********************************************!*\
  !*** ./src/utils/weimob-js-sdk/utils/auth.js ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

function login() {
  return Promise.resolve(true);
}
function loginByPhone() {
  return Promise.resolve(true);
}
module.exports = {
  login,
  loginByPhone
};

/***/ }),

/***/ "./src/utils/weimob-js-sdk/utils/core.js":
/*!***********************************************!*\
  !*** ./src/utils/weimob-js-sdk/utils/core.js ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

class Core {
  constructor(page) {
    this.functions = {};
    this.data = {};
    this._watchers = {}; // 数据监听集合
    this._depends = []; // 页面内的所有自定义组件实例
    this._dependsIds = []; // 页面内的自定义组件实例ID。
    this.pageId = page.__wxExparserNodeId__;
    this.allReady = true;
  }
  events() {
    return {};
  }
  emit(event, args) {
    try {
      const {
        pageId
      } = this;
      return new Promise((resolve, reject) => {
        if (this.events()[pageId] && this.events()[pageId][event]) {
          return this.events()[pageId][event](args, resolve);
        } else {
          resolve(args);
        }
      });
    } catch (e) {
      return Promise.resolve();
    }
  }
  on(event, args) {
    const {
      pageId
    } = this;
    const data = this.events()[pageId] || {};
    if (data[event]) {
      console.error('该事件已注册，请选择其他事件');
      return;
    }
    data[event] = args;
    this.events = function () {
      return {
        [pageId]: data
      };
    };
  }
  setFunction(funcName, funcBody) {
    if (typeof funcName !== 'string') {
      console.error('函数名称类型只能为string');
      return;
    }
    if (typeof funcBody !== 'function') {
      console.error('函数体类型只能为function');
      return;
    }
    this.functions[funcName] = funcBody;
  }
  getFunction(functionName) {
    if (this.functions[functionName]) {
      return this.functions[functionName];
    } else {
      console.error('无此方法，请检查方法名');
      return null;
    }
  }
  setData(key, value) {
    if (typeof key !== 'string' && typeof key !== 'number') {
      console.error('字段key类型只能为string或者number。异常的key:', key);
      return;
    }
    if (key.indexOf('_') === 0) {
      console.error('设置数据失败：setData 的 key 不可以以下划线开头。异常的key:', key);
      return false;
    }
    // 内部字段不允许设置。
    if (['data', 'pageId', 'functions', 'allReady'].includes(key)) {
      console.error('设置数据失败：setData 的 key 违法，请使用其他的key。异常的key: ', key);
      return false;
    }
    const oldValue = this[key];
    this.data[key] = value;

    // 直接将数据代理到顶级
    Object.defineProperty(this, key, {
      get() {
        return value;
      }
    });
    this._update(key, value, oldValue); // 通知观察者去更新数据
  }

  // 通知回调
  _update(key, value, oldValue) {
    // 监听数据的事件们回调处理。
    this._watchers[key] && this._watchers[key].forEach(cb => {
      cb(value, oldValue);
    });
    // 通知本页面的各个自定义组件，数据更新。
    this._depends.forEach(wx_cxt => {
      wx_cxt.setData({
        [key]: value
      });
    });
  }

  /**
   * 观察数据。依赖收集
   * @param {string} name 数据的标识
   * @param {function} cb 数据变化时的回调
   * @returns {function} 返回取消观察的函数。执行一下即取消了cb的订阅
   */
  watch(name, cb) {
    if (typeof cb !== 'function') {
      console.error('订阅数据变化的回调函数类型异常！', name);
      return false;
    }
    this._watchers[name] = this._watchers[name] || [];
    this._watchers[name].push(cb);
    return this._unwatchWait(name, cb);
  }

  /**
   * 取消对 name 数据的 cb 回调观察
   * @param {string} name 数据的标识
   * @param {function} cb 数据变化时的回调
   */
  unwatch(name, cb) {
    if (typeof cb === 'function') {
      // 忽略除了 function 类型之外的第二个参数。
      if (this._watchers[name].includes(cb)) {
        this._watchers[name].splice(this._watchers[name].indexOf(cb), 1);
      } else {
        console.error('没有此回调函数，取消订阅数据失败');
      }
    } else {
      this._watchers[name] = []; // 一次性清空全部
    }
  }

  // 取消数据观察的准备器。
  _unwatchWait(name, cb) {
    return () => {
      this.unwatch(name, cb);
    };
  }

  /**
   * 收集开发者的所有自定义组件实例
   * @param {微信自定义组件实例} wx_cxt
   */
  dependsPush(wx_cxt) {
    // 判断实例是否已收藏过，只push一次
    if (!this._dependsIds.includes(wx_cxt.__wxExparserNodeId__)) {
      this._dependsIds.push(wx_cxt.__wxExparserNodeId__);
      this._depends.push(wx_cxt);
      this.bandDataOnece(wx_cxt); // 立即处理数据
    } else {
      console.warn('该组件已存在', wx_cxt.__wxExparserNodeId__);
    }
  }

  // 给自定义组件实例添加数据。
  bandDataOnece(wx_cxt) {
    for (const key in this.data) {
      wx_cxt.setData({
        [key]: this.data[key]
      });
    }
  }
  checkReady(cb) {
    // let me = this
    return new Promise(resolve => {
      if (!this.allReady) {
        setTimeout(this.checkReady.bind(this, cb || resolve), 0);
      } else {
        if (cb) {
          cb();
        } else {
          resolve();
        }
      }
    });
  }
}
module.exports = Core;

/***/ }),

/***/ "./src/utils/weimob-js-sdk/utils/file.js":
/*!***********************************************!*\
  !*** ./src/utils/weimob-js-sdk/utils/file.js ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

const _HOST = 'http://xxx.appdev.weimobcloud.com';
module.exports = {
  downloadFile(ops) {
    wx.downloadFile({
      ...ops,
      header: {
        ...ops.header
      },
      url: _HOST + ops.url
    });
  }
};

/***/ }),

/***/ "./src/utils/weimob-js-sdk/utils/navigate.js":
/*!***************************************************!*\
  !*** ./src/utils/weimob-js-sdk/utils/navigate.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

class Navigate {
  cleanArray(actual) {
    const newArray = [];
    for (let i = 0; i < actual.length; i++) {
      if (actual[i]) {
        newArray.push(actual[i]);
      }
    }
    return newArray;
  }

  /**
   * 转换queryString
   * @returns {*}
   */
  toQueryString(params) {
    return this.cleanArray(Object.keys(params).map(key => {
      if (params[key] === undefined) return '';
      return encodeURIComponent(key) + '=' + encodeURIComponent(params[key]);
    })).join('&');
  }

  /**
   * 跳转
   * @param option
   */
  jump(option) {
    let url = option.url;
    if (option.queryString) {
      url += '?';
      url += option.queryString;
    }
    wx[option.method]({
      url: url,
      fail() {
        if (option.method === 'navigateTo') {
          wx.redirectTo({
            url: url
          });
        }
      }
    });
  }

  /**
   * 商详页
   * @param {String} method 跳转方式
   * @param {Object } query
   * @param {String } query.goodsId 商品Id
   */
  goodsDetail(method = 'navigateTo', query) {
    if (!query) {
      console.error('缺少必要参数！');
      return;
    }
    if (!query.goodsId) {
      console.error('缺少商品Id！');
      return;
    }
    const option = {
      url: '/pages/goods/detail',
      queryString: this.toQueryString(query),
      method
    };
    this.jump(option);
  }

  /**
   * 购物车
   * @param {String} method 跳转方式
   */
  shopCart(method = 'navigateTo') {
    const option = {
      url: '/pages/shop/cart',
      method
    };
    this.jump(option);
  }

  /**
   * 个人中心
   * @param {String} method 跳转方式
   */
  userCenter(method = 'navigateTo') {
    console.log('跳转至个人中心，真实环境会跳转');
  }

  /**
   * 订单列表
   * @param {String} method 跳转方式
   * @param {Object } query
   */
  orderList(method = 'navigateTo', query) {
    console.log('跳转至订单列表，真实环境会跳转');
  }

  /**
   * 订单详情
   * @param {String} method 跳转方式
   * @param {Object } query
   */
  orderDetail(method = 'navigateTo', query) {
    if (!query) {
      console.error('缺少必要参数！');
      return;
    }
    if (!query.orderNo) {
      console.error('缺少orderNo');
      return;
    }
    console.log('跳转至订单详情，真实环境会跳转');
  }

  /**
   * 物流详情
   * @param {String} method 跳转方式
   * @param {Object } query
   */
  orderExpress(method = 'navigateTo', query) {
    console.log('跳转至物流详情，真实环境会跳转');
  }

  /**
   * 个人信息
   * @param {String} method 跳转方式
   */
  userSettings(method = 'navigateTo') {
    const option = {
      url: '/pages/user/member/info',
      method
    };
    this.jump(option);
    console.log('跳转至个人信息，真实环境会跳转');
  }

  /**
   * 帐号设置
   * @param {String} method 跳转方式
   */
  accountSettings(method = 'navigateTo') {
    console.log('跳转至帐号设置，真实环境会跳转');
  }

  /**
   * 我的优惠券
   * @param {String} method 跳转方式
   */
  userCouponList(method = 'navigateTo') {
    console.log('跳转至我的优惠券，真实环境会跳转');
  }

  /**
   * 积分商城
   * @param {String} method 跳转方式
   */
  pointMall(method = 'navigateTo') {
    console.log('跳转至积分商城，真实环境会跳转');
  }

  /**
   * 分销中心
   * @param {String} method 跳转方式
   */
  salesCenter(method = 'navigateTo') {
    console.log('跳转至分销中心，真实环境会跳转');
  }

  /**
   * 退款/售后列表
   * @param {String} method 跳转方式
   */
  refundList(method = 'navigateTo') {
    console.log('跳转至退款/售后列表，真实环境会跳转');
  }
}
module.exports = new Navigate();

/***/ }),

/***/ "./src/utils/weimob-js-sdk/utils/navigator.js":
/*!****************************************************!*\
  !*** ./src/utils/weimob-js-sdk/utils/navigator.js ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

const SYSTEM_PAGE_PATH_LIST = ['goodsDetail', 'shopCart', 'userCenter', 'orderList', 'orderDetail', 'orderExpress', 'userSettings', 'accountSettings', 'cardPackages', 'userCouponList', 'pointMall', 'salesmanCenter', 'refundList'];
const navigate = __webpack_require__(/*! ./navigate */ "./src/utils/weimob-js-sdk/utils/navigate.js");
/**
 *
 * @param {Object} option 跳转参数
 * @param {string} option.url 跳转地址
 * @param {Object} option.query 跳转携带参数
 * @param {string} option.method [navigateTo,redirectTo,reLaunch,navigateBack]
 */
module.exports = function (option) {
  if (SYSTEM_PAGE_PATH_LIST.indexOf(option.url) < 0) {
    console.error('请传入正确的页面标识,支持跳转的页面请参考文档');
    return;
  }
  navigate[option.url](option.method, option.query);
};

/***/ }),

/***/ "./src/utils/weimob-js-sdk/utils/paas.js":
/*!***********************************************!*\
  !*** ./src/utils/weimob-js-sdk/utils/paas.js ***!
  \***********************************************/
/*! exports provided: relationChain, userPhone */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "relationChain", function() { return relationChain; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "userPhone", function() { return userPhone; });
/**
 * 导购-写入导购与用户的关系链
 * @options [Object] { "pid":10, "wid":xxxx, "ecBizType":"xxxx", "ecBizTicket":"xxxx" }
 * pid 店铺
 * wid 用户
 * ecBizType 对页面分享链接URL解析后的参数之一
 * ecBizTicket 对页面分享链接URL解析后的参数之一
 *
 * @returns [Promise] {success: true} 返回写入结果
 * success [Boolean] true: 写入成功。false：写入失败。
 **/
const relationChain = function (options) {
  return new Promise((resolve, reject) => {
    if (options) {
      return resolve({
        success: true
      });
    } else {
      return reject({
        success: false
      });
    }
  });
};

/**
 * 会员注册 - 解析微信加密数据的真实手机号
 * @options [Object]  { encryptedData: 'xxxx', iv:'xxxx' }
 * encryptedData  微信授权手机号按钮button组件点击后的回调值。
 * iv  微信授权手机号按钮button组件点击后的回调值。
 *
 * @returns [Promise] {success: true, phone: 123456}
 **/
const userPhone = function ({
  encryptedData,
  iv
}) {
  return new Promise((resolve, reject) => {
    if (encryptedData && iv) {
      return resolve({
        success: true,
        phone: 123456
      });
    } else {
      return reject({
        success: false
      });
    }
  });
};

/***/ }),

/***/ "./src/utils/weimob-js-sdk/utils/request.js":
/*!**************************************************!*\
  !*** ./src/utils/weimob-js-sdk/utils/request.js ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

const __baseURL = 'https://612072719085-yxh-login.app.weimobcloud.com';
//const __baseURL = 'https://612072719085-yxh-login.appdev.weimobcloud.com'

/**
 * @method 发送请求
 *
 * @param {Object} option - 请求配置参数
 * @param {string} option.url - 请求路径
 * @param {Object} option.data - 请求参数
 * @param {Object} option.requestOption - 请求配置（参考wx.request 官方文档 https://developers.weixin.qq.com/miniprogram/dev/api/network/request/wx.request.html）
 *
 * @returns {Promise}
 */

module.exports = function (option) {
  return new Promise((resolve, reject) => {
    option.requestOption = option.requestOption || {};
    wx.request({
      url: __baseURL + option.url,
      method: option.requestOption.method || 'POST',
      ...option.requestOption,
      data: {
        wid: '{{wid}}',
        ...option.data
      },
      header: {
        'content-type': 'application/json',
        Accept: 'application/json',
        ...option.requestOption.header
      },
      success: res => {
        if (res.statusCode === 200) {
          resolve(res.data);
        } else {
          reject(res);
        }
      },
      fail: res => {
        reject(res);
      }
    });
  });
};

/***/ }),

/***/ "./src/utils/weimob-js-sdk/utils/retail.api.js":
/*!*****************************************************!*\
  !*** ./src/utils/weimob-js-sdk/utils/retail.api.js ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

let apiMaps;
apiMaps = {
  user_base_info: '***',
  user_asset_info: '***',
  user_card_info: '***',
  user_guider_info: '***',
  user_coupon_list: '***',
  user_coupon_detail: '***',
  user_coupon_packagelist: '***',
  user_coupon_get: '***',
  user_sdp_info: '***',
  user_purchase_list: '****',
  user_purchase_receive: '****',
  wm_app_session: '***'
};
const mockdata = {};
mockdata.user_base_info = {
  headurl: 'https://thirdwx.qlogo.cn/mmopen/vi_32/DYAIOgq83epfglCQ1t6rNl6QykTf5nYHQYMcHichHDDxPKhzNrtKIdfEicGbia2h9mRoXKNVNIHb9sHwx1wUicqI7g/132',
  homeStoreId: null,
  homeStoreName: null,
  isMember: false,
  nickname: '微大盟',
  wid: 10896867013,
  appId: 'wxea5b8710073235fd',
  openId: 'ok3hN5av9sf97Rb-fIJ5e0t0X_jw'
};
mockdata.user_base_info.sourceObjectList = [{
  source: 2,
  sourceAppId: 'wxea5b8710073235fd',
  sourceOpenId: 'user-unionId'
}, {
  source: 4,
  sourceAppId: 'wxea5b8710073235fd',
  sourceOpenId: '17766778877'
}];
mockdata.user_asset_info = {
  availableAmount: 100,
  availablePoint: 10,
  currentAmount: 100,
  currentPoint: 10
};
mockdata.user_card_info = {};
mockdata.user_guider_info = {};
mockdata.user_coupon_list = {};
mockdata.user_coupon_detail = {};
mockdata.user_coupon_packagelist = {
  pageList: [{
    couponOrigin: 1,
    couponPackageId: 1012606,
    couponPackageName: '福袋2号',
    description: '描述',
    sendType: 1,
    status: 1,
    statusDesc: null,
    stock: 0,
    useNotice: '嘤嘤嘤',
    couponList: [{
      acceptGoodsType: 1,
      adaptCurrentStore: true,
      alipayCouponTemplateId: null,
      alipayMerchantCouponRecommendStatus: null,
      applyTradeScene: null,
      authWechatMerchant: null,
      availableTimeEnd: null,
      availableTimeStart: null,
      canCashTicket: null,
      canGiveFriend: null,
      canGoodsNumber: null,
      canReceive: null,
      canShare: null,
      canUseDeductions: null,
      canUseDiscounts: null,
      canWeimobEdit: null,
      cardTemplateId: 1016685,
      cashTicketAmt: 11.0,
      cashTicketCondition: 1.0,
      codeGenerateType: 0,
      colorType: null,
      condition: null,
      couponChannel: null,
      couponCost: null,
      couponCostType: null,
      couponDesc: '',
      couponExtraInfo: null,
      couponOrigin: 1,
      couponScopeList: null,
      couponTagList: null,
      createAreaCode: null,
      createAreaId: null,
      createDate: null,
      createStoreId: null,
      createType: null,
      customCodeSetting: null,
      detail: '价值11元代金券，满足门槛即可使用',
      discount: null,
      excludeGoodsIds: null,
      existExcludeGoods: false,
      expDayCount: null,
      expireDate: 1617206399000,
      expireDateType: 1,
      fromPaas: false,
      iconUrl: null,
      importGoodsFileName: null,
      importGoodsFlag: null,
      isAvailable: null,
      isEnable: null,
      isExpired: null,
      isFocusFollow: null,
      isSyncWechat: null,
      issueChannel: null,
      left: 1000,
      limitedType: null,
      logoUrl: null,
      maxCashTicketAmt: null,
      maxDiscount: null,
      maxDiscountAmount: null,
      maxGoodsAmount: null,
      maxGoodsNumber: null,
      memberTagList: null,
      merchantIssueChannels: null,
      merchantIssueFlag: null,
      merchantName: null,
      minCashTicketAmt: null,
      minDiscount: null,
      minGoodsNumber: null,
      name: 'C型1区域',
      number: 4,
      operatorId: null,
      pid: null,
      pricingType: null,
      publishChannelType: null,
      publishChannels: null,
      publishCount: 0,
      receiveDesc: '每人限领11张',
      recommendEndTime: null,
      recommendStartTime: null,
      redirectType: 0,
      scanBuyIssueFlag: null,
      sceneList: null,
      selectAreaIds: null,
      selectStoreIdList: null,
      selectStoreRangeType: null,
      selectStoreType: 1,
      servicePhone: null,
      settingVersion: null,
      share: null,
      sourceMerchantName: null,
      startDate: 1616515200000,
      startDayCount: null,
      status: 6,
      stockId: null,
      storeId: null,
      storeLaunchFlag: null,
      storeLimitNum: null,
      subCouponType: 1,
      subName: null,
      syncStatus: null,
      textImageList: null,
      thirdId: null,
      totalCount: 1000,
      type: 0,
      useChannels: null,
      useNotice: '满1元且仅1件可用，'
    }]
  }],
  pageNum: 1,
  pageSize: 20,
  totalCount: 3
};
mockdata.user_coupon_get = {
  canReceive: 1,
  // 用户能否领取 1可领取 2已领取 3已领完)
  code: '91904041586615409',
  // 优惠券券码
  state: 1 // 是否领取成功
};
mockdata.user_sdp_info = {};
mockdata.user_purchase_list = {
  status: 0,
  //  0 未领取; 1 已领取; 2 已使用
  memberUsedCount: 0,
  // 会员使用总数
  activityId: 12,
  purchaseUpper: 2,
  purchaseCodeGoodsDTOList: [{
    goodsId: 22,
    goodsTitle: '商品标题',
    defaultImageUrl: 'https://image-c-dev.weimobwmc.com/dev-Omr9/68a90ddf57dd410582a9acca889bcea5.png'
  }]
};
mockdata.user_purchase_receive = {
  codeValues: ['hN5av3bV97Rb', 'bV97RbhN5av3']
};
mockdata.wm_app_session = {
  pid: '3400',
  wid: 6353261854,
  appid: 'wxea5b8710079835fd',
  openid: 'ok3hN5av3bV97Rb-fF9SC7t0X_jw'
};
const init = function (dataflag, option = {}) {
  if (!apiMaps[dataflag]) {
    console.error('您所查询的接口不存在，请核对后再调用！');
  }
  return Promise.resolve(mockdata[dataflag]);
};
module.exports = init;
// export default init;

/***/ })

/******/ });