"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _glob = require("glob");
var _OptionParser = _interopRequireDefault(require("./OptionParser"));
var _createTransformer = _interopRequireDefault(require("./createTransformer"));
var _io = _interopRequireDefault(require("./io"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
/**
 * Lebab command line app
 */
var Cli = /*#__PURE__*/function () {
  /**
   * @param {String[]} argv Command line arguments
   */
  function Cli(argv) {
    _classCallCheck(this, Cli);
    try {
      this.options = new _OptionParser["default"]().parse(argv);
      this.transformer = (0, _createTransformer["default"])(this.options.transforms);
    } catch (error) {
      console.error(error); // eslint-disable-line no-console
      process.exit(2);
    }
  }

  /**
   * Runs the app
   */
  _createClass(Cli, [{
    key: "run",
    value: function run() {
      var _this = this;
      if (this.options.replace) {
        // Transform all files in a directory
        _glob.glob.sync(this.options.replace).forEach(function (file) {
          _this.transformFile(file, file);
        });
      } else {
        // Transform just a single file
        this.transformFile(this.options.inFile, this.options.outFile);
      }
    }
  }, {
    key: "transformFile",
    value: function transformFile(inFile, outFile) {
      try {
        var _this$transformer$run = this.transformer.run(_io["default"].read(inFile)),
          code = _this$transformer$run.code,
          warnings = _this$transformer$run.warnings;

        // Log warnings if there are any
        if (warnings.length > 0 && inFile) {
          console.error("".concat(inFile, ":")); // eslint-disable-line no-console
        }

        warnings.forEach(function (_ref) {
          var line = _ref.line,
            msg = _ref.msg,
            type = _ref.type;
          console.error( // eslint-disable-line no-console
          "".concat(line, ":  warning  ").concat(msg, "  (").concat(type, ")"));
        });
        _io["default"].write(outFile, code);
      } catch (e) {
        console.error("Error transforming: ".concat(inFile, "\n")); // eslint-disable-line no-console
        throw e;
      }
    }
  }]);
  return Cli;
}();
exports["default"] = Cli;