
const tmpComponent = Component

const baseComponent = (option) => {
  option = dealLifeTime(option)
  option.lifetimes = dealLifeTime(option.lifetimes || {})
  if (option.isCreatedAppendData === false && option.lifetimes.isCreatedAppendData === false) {
    option.lifetimes.created = function () {
      getApp().getSdkSync().then(sdk => {
        // 数据传递给自定义组件
        getApp().getSdk().page.dependsPush(this)
      })
    }
  }

  tmpComponent({ ...option })
}

function dealLifeTime (option) {
  option.isCreatedAppendData = false
  for (const lifetime in option) {
    if (['attached', 'created', 'ready'].includes(lifetime)) {
      if (lifetime === 'created') {
        option.isCreatedAppendData = true
      }
      const fnTemp = option[lifetime]
      option[lifetime] = function () {
        getApp().getSdkSync().then(sdk => {
          if (lifetime === 'created') {
            getApp().getSdk().page.dependsPush(this)
          }
          fnTemp.call(this, arguments)
        })
      }
    }
  }
  return option
}

export default baseComponent
