"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = _default;
var _fp = require("lodash/fp");
var _traverser = _interopRequireDefault(require("../traverser"));
var _isEqualAst = _interopRequireDefault(require("../utils/isEqualAst"));
var _variableType = require("../utils/variableType");
var _copyComments = _interopRequireDefault(require("../utils/copyComments"));
var _matchAliasedForLoop = _interopRequireDefault(require("../utils/matchAliasedForLoop"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _default(ast, logger) {
  _traverser["default"].replace(ast, {
    enter: function enter(node) {
      var matches = (0, _matchAliasedForLoop["default"])(node);
      if (matches) {
        if (indexUsedInBody(matches)) {
          logger.warn(node, 'Index variable used in for-loop body', 'for-of');
          return;
        }
        if (matches.itemKind === 'var' || matches.indexKind === 'var') {
          logger.warn(node, 'Only for-loops with let/const can be tranformed (use let transform first)', 'for-of');
          return;
        }
        return withComments(node, createForOf(matches));
      }
      if (node.type === 'ForStatement') {
        logger.warn(node, 'Unable to transform for loop', 'for-of');
      }
    }
  });
}
function indexUsedInBody(_ref) {
  var body = _ref.body,
    index = _ref.index;
  return _traverser["default"].find(removeFirstBodyElement(body), function (node, parent) {
    return (0, _isEqualAst["default"])(node, index) && (0, _variableType.isReference)(node, parent);
  });
}
function withComments(node, forOf) {
  (0, _copyComments["default"])({
    from: node,
    to: forOf
  });
  (0, _copyComments["default"])({
    from: node.body.body[0],
    to: forOf
  });
  return forOf;
}
function createForOf(_ref2) {
  var item = _ref2.item,
    itemKind = _ref2.itemKind,
    array = _ref2.array,
    body = _ref2.body;
  return {
    type: 'ForOfStatement',
    left: {
      type: 'VariableDeclaration',
      declarations: [{
        type: 'VariableDeclarator',
        id: item,
        init: null // eslint-disable-line no-null/no-null
      }],

      kind: itemKind
    },
    right: array,
    body: removeFirstBodyElement(body)
  };
}
function removeFirstBodyElement(body) {
  return _objectSpread(_objectSpread({}, body), {}, {
    body: (0, _fp.tail)(body.body)
  });
}