import Dream from ".."
import { UseAni } from "../../modules/UseDecorator/useAni"
import {
  EventsMap
} from '../types'

type DreamFC<T extends Record<string, any> = {}, R extends any = FYGE.Container> = (props: {
  ref?: (c: R) => void,
  inlineProps?: Record<string, any>
  children?: FYGE.Container[], // 这样写的话，外面也能提示了 -。-
} & T) => FYGE.Container

type OriginalElementWidthEvents<extraProps={}, T = FYGE.Container> = DreamFC<EventsMap & extraProps, T>

type DrawData = {
  'rect': [number, number, number, number],
  'circle': [number, number, number]
}

export const FPShapeOfRectV2: DreamFC<Partial<{
  type: keyof DrawData,
  drawData: any,
  fillColor: string,
  alpha: number
}>> = function ({
  type = 'rect',
  fillColor = '#000000',
  alpha = 1,
  drawData = [0, 0, 750, 1624]
}) {
  const graphicsIns = new FYGE.Shape()
  graphicsIns.beginFill(fillColor)
  if (type === 'rect') {
    graphicsIns.drawRect(drawData[0], drawData[1], drawData[2], drawData[3])
  } else if (type === 'circle') {
    graphicsIns.drawCircle(drawData[0], drawData[1], drawData[2])
  }
  graphicsIns.endFill()
  graphicsIns.alpha = alpha
  return graphicsIns
}

function ScaleAni(t: number) {
  return function(c: FYGE.Container) {
    return new Promise(async (r) => {
      FYGE.Tween.removeTweens(c)
      c.scale.set(0, 0)
      FYGE.Tween.get(c, {
        loop: true
      })
        .to({scaleX: 1, scaleY: 1}, 500, FYGE.Ease.quadInOut)
        .to({scaleX: 0, scaleY: 0}, 500,  FYGE.Ease.quadInOut)
        .wait(1000)
    })
  }
}

export const DotAni: OriginalElementWidthEvents<{
  delay: number,
  radius: number
}> = function({
  delay,
  radius
}) {
  
  const Cls: any = UseAni({
    showCall: ScaleAni(delay)
  })(function() {
    const shapIns = new FYGE.Shape()
    shapIns.beginFill('#43b99f')
    shapIns.drawCircle(0, 0, radius)
    shapIns.endFill()
    return shapIns
  })
  return <Cls></Cls>
}

export class DreamDotAni extends Dream.RenderContainer {
  cont: FYGE.Container

  render() {
    return (
      <FYGE.Container inlineProps={{
        x: 300,
        y: 750
      }} ref={(el: FYGE.Container) => {
        this.cont = el
      }}>
        {
          Array.from({
            length: 3
          }, (_, index) => {
            return (
              <DotAni inlineProps={{
                x: 100 * index,
              }} delay={index * 150} radius={40}></DotAni>
            )
          })
        }
      </FYGE.Container>
    )
  }
}

export const Container: OriginalElementWidthEvents = function() {
  return (
    <FYGE.Container>
    </FYGE.Container>
  )
}

export class DreamSpriteV2 extends Dream.RenderContainer<{
  src: string | FYGE.Texture
}> {
  notifyDisplayChange(w: number, h: number) {
    let t = this.wrapperCont.parent
    if (t.isInDisplay) {
      t.sw = w
      t.sh = h
    }
    while(t) {
      t.dispatchEvent('updateDisplay')
      t = t.parent
    }
  }

  wrapperCont: FYGE.Container
  render() {
    const {
      src
    } = this.props
    let _sp: FYGE.Sprite
    if (typeof src === 'string') {
      _sp = new FYGE.Sprite()
      // 记得改一下 可能是加载过的
      FYGE.GlobalLoader.loadImage((s, image) => {
        if (s && image) {
          const texture = FYGE.Texture.fromImage(image!)
          _sp.texture = texture
          this.notifyDisplayChange(texture.width, texture.height)
        }
      }, src)
    } else {
      _sp = new FYGE.Sprite(src)
    }
    this.wrapperCont = _sp
    return _sp
  }
}