import Dream from "../Dream";
import { DotAni, DreamDotAni, DreamSpriteV2, FPShapeOfRectV2 } from "../Dream/UI";
import { fadeInFactory } from "../modules/animations";
import { layers } from "../modules/layers";
import { SceneController } from "../modules/layers/ctrls";
import { ModalCtroller } from "../modules/ModalControl";
import { RES } from "../modules/RES";
import { UseAni } from "../modules/UseDecorator/useAni";
import { UsePreload } from "../modules/UseDecorator/usePreload";
import { Sprite } from "../UI/Sprite";
import { PreloadeTest } from "./test";

@UseAni({
  showCall: fadeInFactory(500),
  hideCall: fadeInFactory(500)
})
class Test extends Dream.RenderContainer{
  render() {
    return (
      <FYGE.Container>
        <DreamSpriteV2 src="http://qnpic.top/yoona2.jpg"></DreamSpriteV2>
      </FYGE.Container>
    )
  }
}

@UseAni({
  showCall: function(t) {
    return new Promise(r => {
      FYGE.Tween.removeTweens(t)
      const oy = t.y
      FYGE.Tween.get(t)
        .set({y: oy + 400})
        .to({y: oy}, 300)
        .call(r)
    })
  }
})
class PT extends Dream.RenderContainer {
  render() {
    const props = this.props
    return <FYGE.TextField onClick={() => {
      props.closeModal && props.closeModal()
      ModalCtroller.showModal(PT, {}, {
        destroy: false
      })
    }} inlineProps={{
      text: '???',
      size: 100,
      fillColor: '#000000'
    }}></FYGE.TextField>
  }
}

@UsePreload({
  resList: [
    'http://qnpic.top/yoona2.jpg'
  ],
  resPreloadFunc: {
    // jpg: function(src, cb) {
    //   console.log('我就来玩玩', src)
    //   cb()
    //   return new Promise<void>(r => {
    //     r()
    //   })
    // }
  },
  preAction: async function() {
    await RES.loadGroup('')
  }
})
export class HomeScene extends Dream.RenderContainer {
  cont: FYGE.Container

  addFadeinCont() {
    this.cont.addChild(<Test tt={3} ref={(el: any) => {
      setTimeout(() => {
        el.hideAni()
      }, 3000)
    }}></Test>)
  }

  testModal() {
    // ModalCtroller.showModal(PT, {}, {
    //   destroy: false
    // })
    SceneController.changeScene(PT, {
      test: 123123
    })
  }

  render() {

    return (
      // <DreamSpriteV2 src="http://qnpic.top/yoona2.jpg"></DreamSpriteV2>
      <FYGE.Container ref={(el: any) => {
        this.cont = el
      }}>
        <FYGE.TextField onClick={() => {
          // this.addFadeinCont()
          this.testModal()
        }} inlineProps={{
          text: '杭州要下雨',
          size: 90,
          fillColor: '#000000'
        }}></FYGE.TextField>
        {/* <Sprite src="http://qnpic.top/yoona12.jpg"></Sprite> */}
      </FYGE.Container>
    )
  }  
}