const parser = require('@babel/parser')
const traverse = require('@babel/traverse').default
const template = require('@babel/template').default
const generate = require('@babel/generator').default

const ast = parser.parse(`
  const a = 3
  const b = <a></a>
  console.log(12323)
  f()
  class Clazz {
    render() {
      return (
        <div>
        {console.log(11)}
      </div>
      )
    }
  }
`, {
  sourceType: 'unambiguous',
  plugins: ['jsx']
})

const t = ['log', 'info'].map(s => `console.${s}`)

traverse(ast, {
  CallExpression(path, state) {
    const node = path.node
    if (node.isSkip) return
    const str = path.get('callee').toString()
    if (t.includes(str)) {
      const newNode = template.expression(`console.log('========${str}======')`)()
      path.insertBefore(newNode)
      newNode.isSkip = true
      node.isSkip = true
    }
  }
})

const {
  code
} = generate(ast)
console.log(code)
