export function fadeInFactory(t: number) {
  return function(cont: FYGE.Container) {
    return new Promise(r => {
      FYGE.Tween.removeTweens(cont)
      FYGE.Tween.get(cont)
        .set({alpha: 0})
        .to({
          alpha: 1
        }, t, FYGE.Ease.quadIn)
        .call(r)
    })
  }
}

export function fadeOutFactory(t: number) {
  return function(cont: FYGE.Container) {
    return new Promise(r => {
      FYGE.Tween.removeTweens(cont)
      FYGE.Tween.get(cont)
        .to({
          alpha: 0
        }, t, FYGE.Ease.quadIn)
        .call(r)
    })
  }
}
