import Dream from "../Dream";
import { RES } from "../modules/RES";

export class Sprite extends Dream.RenderContainer<{
  src: string | FYGE.Texture
}> {
  render() {
    const {
      src
    } = this.props

    const sp = new FYGE.Sprite()

    if (typeof src === 'string') {
      RES.getResAsync(src, (d: FYGE.Texture) => {
        sp.texture = d
      })
    } else {
      sp.texture = src
    }
    return sp
  }
}