## 利用babel 简化 FYGE 的开发方式

> 本质上 利用jsx 的用法， 让我们 编写页面逻辑的时候，能够能搞的 ui层和 数据层分开，在一定程度上可以 简化开发思路

jsx => new => render  => back

生命周期 就很简单 render => ref => didRendered

ref 会在 改节点 didRendered 完成之后才会执行，用nextTick 微任务 实现


### 优势

> 本质上是为了 让开发模式上 的改变，在一定程度我们可以 用类似 react 的方式去做 。我们可以写一些 我们更好理解的 东西， 比如我们 写一个 Img 组件，支持src 里面就我们 资源组的 name 或者 直接网络图地址的形式 

```javascript
export class Sprite extends Dream.RenderContainer<{
  src: string | FYGE.Texture
}> {
  render() {
    const {
      src
    } = this.props

    const sp = new FYGE.Sprite()

    if (typeof src === 'string') {
      RES.getResAsync(src, (d: FYGE.Texture) => {
        sp.texture = d
      })
    } else {
      sp.texture = src
    }
    return sp
  }
}
```

基本除了 没有diff 这一层，在一定程度上都是 可以用 react 的方式去做。 Just for try。

### 注意事项

> 本质上先阶段只是 一个简单的 用例， 其主要实现就是 Dream 下的 development.

> useAni 默认会去 清除 子元素上的所有tween，所以，里面的tween 不要加 延时，否则会清除不掉

> 装饰器 ts 推导有点问题 UseAni

> 场景 这里怎么处理好呢， 怎么判定 是预加载，或者，预加载的时候，需要下层 场景呢
> 场景需要切换的时候 带有动画呢，做锤子🔨

new => RenderComponent => render => back

ref <= didRendered

new => FYGE.Container

FYGE.Shape 画出来的  width 和height 外面又一层 20 ？？