import { DreamContainer } from "../../components/DreamContainer/DreamContainer";
import { DreamShape } from "../../components/DreamShape/DreamShape";
import { DreamSprite } from "../../components/DreamSprite/DreamSprite";
import { DreamTextField } from "../../components/DreamTextField/DreamTextField";
import Dream from "../../Dream";
import { SceneController } from "../../modules/layers/ctrls";
import { RES } from "../../modules/RES";
import { UsePreload } from "../../modules/UseDecorator/usePreload";
import { GameScene } from "../GameScene/GameScene";

@UsePreload({
  async preAction() {
    await RES.loadGroup('NewGuyScene')
  }
})
export class NewGuyScene extends Dream.RenderContainer {
  SceneContainer: FYGE.Container
  GuideContainer: FYGE.Container
  didRendered(): void {
    let step = 1
    const nextStep = () => {
      showStep(step++)
    }
    const showStep = (s: number) => {
      this.GuideContainer.removeAllChildren()
      const fontSize = 34
      switch(s) {
        case 1:
          this.GuideContainer.addChild(<DreamContainer onClick={nextStep}>
            <DreamSprite src={RES.getRes('Guide1.png')} />
          </DreamContainer>)
          break
        case 2:
          this.GuideContainer.addChild(<DreamContainer onClick={nextStep}>
            <DreamSprite src={RES.getRes('Guide5.png')} />
          </DreamContainer>)
          break
        case 3:
          this.GuideContainer.addChild(<DreamContainer onClick={nextStep}>
            <DreamSprite src={RES.getRes('Guide2.png')} />
          </DreamContainer>)
          break
        case 4:
          this.GuideContainer.addChild(<DreamContainer onClick={nextStep}>
            <DreamSprite src={RES.getRes('Guide3.png')} />
          </DreamContainer>)
          break
        case 5:
          this.GuideContainer.addChild(<DreamContainer onClick={nextStep}>
            <DreamSprite src={RES.getRes('Guide4.png')} />
          </DreamContainer>)
          break
        case 6:
          // 完成新手引导
          SceneController.changeScene(GameScene)
          break

      }
    }
    nextStep()
  }
  

  render() {
    return (
      <DreamContainer ref={el => {
        this.SceneContainer = el
      }}>
        <DreamContainer ref={el => {
          this.GuideContainer = el
        }} ></DreamContainer>
      </DreamContainer>
    )
  }
}