import { DreamContainer } from "../../components/DreamContainer/DreamContainer";
import { DreamSprite } from "../../components/DreamSprite/DreamSprite";
import { DreamTextField } from "../../components/DreamTextField/DreamTextField";
import Dream from "../../Dream";
import { layers } from "../../modules/layers";
import { RES } from "../../modules/RES";
import { GameConfig } from "./GameConfig";

export class SpClock extends Dream.RenderContainer {
  RoleCont: FYGE.Container
  CountText: FYGE.TextField
  set visible(v: boolean) {
    this.RoleCont.visible = v
  }
  _countTime: number = GameConfig.spCountTime
  get countTime() {
    return Math.floor(this._countTime / 1000 )
  }
  set countTime(v: number) {
    this._countTime = v
    this.CountText.text = Math.floor(v / 1000) + 's'
  }

  didRendered(): void {
    this.visible = false
  }

  cobj = {t: 3000}
  onShowCountDown(cb: Function, exT: number) {
    this.cobj.t = GameConfig.spCountTime + exT
    this.visible = true
    FYGE.Tween.removeTweens(this.cobj)
    FYGE.Tween.get(this.cobj, {
      onChange: () => {
        this.countTime = this.cobj.t
      }
    })
      .to({
        t: 0
      }, GameConfig.spCountTime + exT)
      .call(() => {
        this.visible = false
        cb()
      })
  }

  render() {
    const roleCont = RES.getRes('clockBack.png')
    return (
      <DreamContainer ref={el => {
        this.RoleCont = el
      }} inlineProps={{
        x: 640,
        y: layers.stageOffsetY + 50
      }}>
        <DreamSprite src={roleCont} />
        <DreamTextField
        ref={el => this.CountText = el}
        text={this.countTime + 's'} color="#ffffff"
        textWidth={roleCont.width + 5}
        textHeight={roleCont.height}
        stroke={2}
        size={32}
        strokeColor="#a45549"
        />
      </DreamContainer>
    )
  }
}