import { DreamContainer } from "../../components/DreamContainer/DreamContainer";
import { DreamSprite } from "../../components/DreamSprite/DreamSprite";
import { DreamTextField } from "../../components/DreamTextField/DreamTextField";
import Dream from "../../Dream";
import { layers } from "../../modules/layers";
import { RES } from "../../modules/RES";

export class ScoreBoard extends Dream.RenderContainer {
  _score:number = 0
  ScoreText: FYGE.TextField
  get score() {
    return this._score
  }

  set score(v: number) {
    this._score = v
    this.ScoreText.text = v + ''
  }

  render() {
    const roleCont = RES.getRes('scoreBoardBack.png')
    return (
      <DreamContainer inlineProps={{
        y: layers.stageOffsetY + 50,
        x: 375 - roleCont.width / 2
      }}>
        <DreamSprite src={roleCont} />
        <DreamTextField ref={el => {
          this.ScoreText = el
        }} text={this.score + ''} size={36} bold textWidth={roleCont.width} color="#9a4136" textHeight={roleCont.height} />
      </DreamContainer>
    )
  }
}