import { DreamContainer } from "../../components/DreamContainer/DreamContainer";
import { DreamSprite } from "../../components/DreamSprite/DreamSprite";
import { DreamSvgaAni } from "../../components/DreamSvgaAni/DreamSvgaAni";
import { DreamTextField } from "../../components/DreamTextField/DreamTextField";
import Dream from "../../Dream";
import { fadeOutUpFactory } from "../../modules/animations";
import { RES } from "../../modules/RES";
import { GameConfig } from "./GameConfig";

export class Platform extends Dream.RenderContainer<{
  type: number // 1 就是默认 2 道具 3 炸弹
  x: number
  pos?: [number, number]
}> {
  private isLanded: boolean = false // 是否被踩过
  private spCont: FYGE.Container
  PlatformContainer: FYGE.Container
  onLand(cb?: (type: number, s: number, afterCb: Function) => void) {

    const ctype = this.isLanded ? 1 : this.props.type
    cb && cb(ctype, this.isLanded ? 0 : GameConfig.landPlatformScore, () => {
      if (ctype !== 1 && this.spCont) {
        // fadeOutUpFactory(500)(this.spCont)
        this.spCont.visible = false
        if (ctype == 3) {
          const atom = new FYGE.SvgaAni(RES.getRes('boomSvga.svga'))
          atom.position.set(-50, -162)
          atom.play(1, () => {
            atom.parent.removeChild(atom)
          })
          this.PlatformContainer.addChild(
            atom
          )
        } else if (ctype == 2) {
          const atom = new FYGE.SvgaAni(RES.getRes('spSvga.svga'))
          atom.position.set(-100, -320)
          atom.play(1, () => {
            atom.parent.removeChild(atom)
          })
          this.PlatformContainer.addChild(
            atom
          )
        }
      }
    })
    this.isLanded = true
  }

  /**
   * 渲染道具
   * @returns 
   */
  renderSp() {
    if (this.props.type == 2) {
      return this.spCont = <DreamSprite inlineProps={{
        x: 28,
        y: -100
      }} src={RES.getRes('sp_milk.png')} />
    } else if (this.props.type == 3) {
      return this.spCont = <DreamSvgaAni
        inlineProps={{
          x: 20,
          y: -85
        }}
      svgaData={RES.getRes('SpBoom.svga')} />
    }
  }

  render() {
    const backRes = RES.getRes('platform.png')
    return (
      <DreamContainer ref={el => {
        this.PlatformContainer = el
      }} inlineProps={{
        x: this.props.x || 0
      }}>
        <DreamSprite src={backRes} inlineProps={{
          x: 2
        }} />
        {
          this.renderSp()
        }
        {
          GameConfig.debugger && this.props.pos && (
            <DreamTextField text={this.props.pos.join(',')} />
          )
        }
      </DreamContainer>
    )
  }
}