import { layers } from "../../modules/layers";

// type 1 正常 2必出道具 3必出炸弹 4 随机出 道具 5 随机出炸弹
// 一行中 最多一个炸弹，这样配合 概率就不会导致出现死局

export const GameConfig = {
  debugger: false,
  sp_p: 0.3, // 出现道具的 概率
  sp_b: 0.8, // 出现炸弹的概率
  offsetYLen: 180,
  offsetXLen: 150, // 格子间隔
  rowNum: 30, // 单个地图的显示 行数
  speed: 100, // 卷轴速度
  mapChangeAddSpeed: 10, // 切换地图就会 增加速度
  renderMapScreenNum: 200, //当卷轴 移动到视窗上面多少 会去生成地图
  rabbitConfig: {
    offsetX: 70,
    offsetY: 30,
  },
  DecisionLine: [
    // 判定线 当前屏幕显示区域
    800,
    layers.stageHeight, // 这里个需要后续设定
  ],
  landPlatformScore: 2, // 平台上的分数
  spCountTime: 3100, //道具倒计时
  boxColNum: 5, // 几列格子
  sptMap: {
    initPos: {
      x: 1,
      y: 26,
    },
    boxMap: [
      [0, 0, 1, 0, 0],
      [0, 0, 1, 2, 0],
      [0, 0, 1, 1, 0],
      [0, 1, 0, 0, 1],
      [0, 0, 1, 1, 0],
      [0, 0, 0, 1, 1],
      [0, 0, 1, 1, 0],
      [0, 2, 1, 0, 0],
      [1, 0, 0, 1, 0],
      [0, 0, 1, 0, 1],
      [0, 1, 0, 1, 0],
      [1, 0, 1, 0, 0],
      [0, 1, 0, 0, 1],
      [1, 0, 0, 1, 0],
      [0, 1, 2, 0, 0],
      [0, 1, 1, 0, 0],
      [1, 0, 0, 1, 0],
      [0, 2, 0, 0, 1],
      [1, 0, 1, 0, 0],
      [1, 1, 0, 1, 0],
      [0, 0, 1, 0, 0],
      [1, 1, 0, 1, 0],
      [0, 0, 1, 0, 1],
      [1, 0, 0, 6, 1],
      [0, 1, 0, 1, 0],
      [0, 1, 1, , 0],
      [1, 1, 0, 0, 0],
      [0, 0, 1, 0, 1],
      [0, 1, 0, 2, 0],
      [0, 0, 1, 0, 0],
    ],
  },
  mapList: [
    {
      initPos: {
        x: 2,
        y: 26,
      },
      boxMap: [
        [0, 1, 0, 1, 3],
        [0, 4, 1, 0, 0],
        [4, 0, 0, 5, 0],
        [0, 1, 1, 0, 1],
        [4, 3, 0, 1, 0],
        [0, 1, 1, 1, 0],
        [5, 0, 0, 0, 1],
        [1, 0, 1, 1, 1],
        [0, 4, 0, 0, 5],
        [1, 0, 1, 0, 0],
        [0, 1, 0, 5, 0],
        [4, 1, 0, 1, 0],
        [0, 0, 1, 0, 5],
        [1, 1, 0, 5, 1],
        [0, 1, 0, 0, 0],
        [1, 0, 0, 4, 0],
        [0, 1, 5, 0, 5],
        [1, 1, 0, 0, 0],
        [0, 0, 1, 0, 1],
        [2, 5, 0, 1, 0],
        [0, 0, 0, 0, 2],
        [1, 0, 4, 0, 0],
        [0, 5, 0, 0, 2],
        [1, 4, 0, 2, 0],
        [4, 0, 0, 4, 0],
        [2, 1, 0, 4, 5],
        [0, 3, 1, 0, 4],
        [4, 0, 0, 5, 0],
        [0, 4, 2, 0, 1],
        [1, 1, 1, 1, 1],
      ],
    },
    {
      initPos: {
        x: 2,
        y: 26,
      },
      boxMap: [
        [4, 0, 1, 1, 1],
        [0, 0, 1, 0, 1],
        [5, 0, 0, 5, 0],
        [0, 2, 0, 0, 1],
        [0, 0, 0, 1, 0],
        [1, 1, 1, 0, 0],
        [0, 1, 0, 0, 0],
        [5, 0, 1, 5, 0],
        [0, 0, 0, 0, 1],
        [0, 0, 1, 1, 0],
        [0, 4, 0, 0, 1],
        [0, 0, 0, 1, 0],
        [2, 0, 5, 0, 5],
        [0, 0, 0, 4, 0],
        [0, 1, 0, 0, 1],
        [1, 0, 1, 0, 0],
        [0, 5, 1, 5, 0],
        [1, 0, 0, 0, 1],
        [4, 1, 0, 0, 0],
        [0, 0, 1, 0, 1],
        [1, 0, 4, 0, 3],
        [0, 1, 0, 1, 0],
        [0, 0, 0, 1, 1],
        [0, 0, 4, 0, 1],
        [2, 0, 0, 3, 0],
        [0, 5, 0, 0, 4],
        [1, 0, 1, 0, 0],
        [0, 0, 1, 0, 4],
        [4, 0, 0, 4, 0],
        [0, 1, 1, 1, 0],
      ],
    },
    {
      initPos: {
        x: 2,
        y: 26,
      },
      boxMap: [
        [1, 0, 0, 1, 5],
        [0, 0, 1, 1, 0],
        [4, 1, 0, 0, 1],
        [1, 0, 0, 0, 1],
        [1, 5, 0, 0, 0],
        [0, 0, 0, 1, 1],
        [1, 0, 4, 0, 1],
        [0, 0, 2, 0, 1],
        [5, 0, 0, 5, 0],
        [0, 1, 2, 0, 1],
        [1, 0, 0, 1, 0],
        [0, 5, 0, 0, 5],
        [4, 0, 0, 4, 0],
        [0, 0, 1, 1, 1],
        [0, 1, 1, 2, 1],
        [1, 0, 0, 0, 0],
        [0, 1, 0, 4, 0],
        [1, 0, 0, 0, 1],
        [3, 0, 4, 1, 1],
        [1, 0, 0, 0, 0],
        [1, 0, 0, 2, 1],
        [1, 0, 0, 0, 0],
        [5, 0, 3, 0, 1],
        [4, 1, 0, 1, 0],
        [0, 0, 0, 0, 1],
        [4, 0, 4, 1, 0],
        [0, 0, 1, 0, 5],
        [1, 4, 0, 0, 0],
        [0, 0, 0, 4, 1],
        [1, 1, 1, 0, 1],
      ],
    },
    {
      initPos: {
        x: 2,
        y: 27,
      },
      boxMap: [
        [1, 0, 5, 0, 1],
        [1, 1, 0, 0, 1],
        [0, 4, 0, 4, 0],
        [1, 0, 0, 1, 1],
        [0, 5, 5, 0, 0],
        [0, 1, 4, 0, 0],
        [1, 1, 0, 1, 1],
        [0, 1, 0, 1, 0],
        [0, 1, 4, 1, 0],
        [1, 1, 3, 1, 1],
        [0, 5, 0, 5, 0],
        [0, 0, 1, 0, 0],
        [0, 0, 1, 1, 1],
        [0, 1, 1, 5, 2],
        [1, 0, 0, 0, 0],
        [0, 1, 0, 1, 0],
        [4, 0, 0, 0, 1],
        [1, 0, 4, 4, 1],
        [1, 0, 0, 0, 1],
        [3, 0, 2, 0, 1],
        [1, 0, 0, 0, 0],
        [0, 1, 0, 1, 0],
        [1, 0, 2, 0, 1],
        [5, 0, 0, 0, 5],
        [0, 1, 0, 1, 0],
        [0, 0, 1, 0, 0],
        [0, 4, 0, 4, 0],
        [1, 3, 1, 1, 1],
        [1, 0, 2, 0, 1],
        [0, 1, 0, 1, 0],
      ],
    },
  ],
};
