export function fadeInFactory(t: number) {
  return function(cont: FYGE.Container) {
    return new Promise(r => {
      FYGE.Tween.removeTweens(cont)
      FYGE.Tween.get(cont)
        .set({alpha: 0})
        .to({
          alpha: 1
        }, t, FYGE.Ease.quadIn)
        .call(r)
    })
  }
}

export function fadeOutFactory(t: number) {
  return function(cont: FYGE.Container) {
    return new Promise(r => {
      FYGE.Tween.removeTweens(cont)
      FYGE.Tween.get(cont)
        .to({
          alpha: 0
        }, t, FYGE.Ease.quadIn)
        .call(r)
    })
  }
}

export function fadeOutUpFactory(t: number, upLen: number = 200) {
  return function(cont: FYGE.Container) {
    return new Promise<void>(r => {
      FYGE.Tween.removeTweens(cont)
      const oy = cont.y
      FYGE.Tween.get(cont, {
        onChange: () => {
          cont.y = (oy - upLen * (1 - cont.alpha))
        }
      })
        .set({alpha: 1})
        .to({
          alpha: 0
        }, t, FYGE.Ease.quadIn)
        .call(() => {
          setTimeout(() => {
            cont.y = oy
          })
          r()
        })
    })
  }
}


export function BounceOutAni(t: number = 1000) {
  return function (cont: FYGE.Container) {
    return new Promise(r => {
      const oy = cont.position.y
      cont.position.y -= 100
      FYGE.Tween.get(cont)
        .to({
          y: oy
        }, t, FYGE.Ease.bounceOut)
    })
  }
}

/**
 * 因为一些不可抗因素导致拿不到最后的 真是宽高
 * @param Con 
 * @param proptyName 
 * @returns 
 */
function getBoundsPropty(Con: FYGE.Container, proptyName: string): any {
  // @ts-ignore
  return Con[proptyName] || (Con.children.length == 1 ? getBoundsPropty(Con.children[0] as FYGE.Container, proptyName) : Con[proptyName])
}

export function slideTop(t: number, tl?: number) {
  return function(cont: FYGE.Container) {
    return new Promise(r => {
      const oy = cont.y
      const ftl = tl || getBoundsPropty(cont, 'height') || 400
      FYGE.Tween.removeTweens(cont)
      FYGE.Tween.get(cont)
        .set({y: oy+ftl})
        .to({
          y: oy
        }, t, FYGE.Ease.quadInOut)
        .call(r)
    })
  }
}
