import Dream from "../../Dream";
import { RES } from "../../modules/RES";
import { UsePreload } from "../../modules/UseDecorator/usePreload";
import { DreamContainer } from "../DreamContainer/DreamContainer";
import { DreamSprite } from "../DreamSprite/DreamSprite";
import { DreamTextField } from "../DreamTextField/DreamTextField";

@UsePreload({
  async preAction() {
    await RES.loadGroup('common')
  },
  loadingComponent: null
})
export class DreamWaiting extends Dream.RenderContainer<{
  msg?: string
}> {



  render() {
    const roleCont = RES.getRes('waitingBg.png')
    const rotCont = RES.getRes('waitingRot.png')
    let count = 0
    const {
      msg = '加载中...'
    } = this.props
    return (
      <DreamContainer>
        <DreamSprite src={roleCont} />
        <DreamSprite src={rotCont} inlineProps={{
          y: 55,
          x: roleCont.width / 2 - rotCont.width / 2,
          anchorX: rotCont.width / 2,
          anchorY: rotCont.height / 2
        }} onEnterFrame={(e) => {
          count++
          if (count % 30 == 0) {
            (e.target as FYGE.Sprite).rotation += 45
          }
        }} />
        <DreamTextField text={msg} color='#ffffff' size={26} textWidth={roleCont.width} inlineProps={{
          y: 126
        }} />
      </DreamContainer>
    )
  }
}