import { OriginalElementWidthEvents } from "../../Dream"

type DrawData = {
  'rect': [number, number, number, number],
  'circle': [number, number, number]
}

export const DreamShape: OriginalElementWidthEvents<Partial<{
  type: keyof DrawData,
  drawData: any,
  fillColor: string,
  alpha: number
}>, FYGE.Shape> = function({
  type = 'rect',
  fillColor = '#000000',
  alpha = 1,
  drawData = [0, 0, 750, 1624]
}) {
  const graphicsIns = new FYGE.Shape()
  graphicsIns.beginFill(fillColor)
  if (type === 'rect') {
    graphicsIns.drawRect(drawData[0], drawData[1], drawData[2], drawData[3])
  } else if (type === 'circle') {
    graphicsIns.drawCircle(drawData[0], drawData[1], drawData[2])
  }
  graphicsIns.endFill()
  graphicsIns.alpha = alpha
  return graphicsIns
}