import { addChildFromParent, createElement } from "./development";
import { RenderContainer } from "./renderContainer";
import { EventsMap } from "./types";
import { nextTick } from "./utils";

export type DreamProps<T extends Record<string, any>, R = FYGE.Container> = {
  ref?: (c: R) => void,
  inlineProps?: Record<string, any>
  className?: string
  children?: FYGE.Container[], // 这样写的话，外面也能提示了 -。-
} & T

export type DreamFC<T extends Record<string, any> = {}, R extends any = FYGE.Container> = (props: {
  ref?: (c: R) => void,
  inlineProps?: Record<string, any>
  className?: string
  children?: FYGE.Container[], // 这样写的话，外面也能提示了 -。-
} & T) => FYGE.Container

export type OriginalElementWidthEvents<extraProps={}, T = FYGE.Container> = DreamFC<EventsMap & extraProps, T>

export default {
  createElement: createElement,
  RenderContainer: RenderContainer,
  VirtualRender: addChildFromParent,
  nextTick: nextTick
}